/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchParams;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearchResults;
import com.cenqua.fisheye.cvsrep.quicksearch.QuickSearcher;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.UrlHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;

public class QuickSearchAction
extends BaseAction {
    public long computeLastModified() throws DbException {
        return this.computeRepositoryLastModified();
    }

    public BaseAction handleRequest() throws ServletException, DbException {
        final HttpServletRequest req = this.getRequest();
        RepositoryConfig rcfg = this.getPathInfo().getRepository();
        final RepositoryEngine engine = this.getPathInfo().getEngine();
        Path lpath = this.getPathInfo().getLocalPath();
        Path fpath = this.getPathInfo().getFullPath();
        RevisionCache rep = engine.getRevisionCache();
        LuceneConnection lConn = engine.getLuceneConnection();
        if (rep.isFile(lpath)) {
            lpath = lpath.getParent();
            fpath = fpath.getParent();
        }
        if (!rep.isDir(lpath)) {
            lpath = new Path();
        }
        final QuickSearchParams params = this.setupParams(rcfg, engine, lpath);
        req.setAttribute("searchAllDirs", (Object)params.isSearchAllDirs());
        req.setAttribute("repname", (Object)rcfg.getName());
        req.setAttribute("repnamePath", (Object)new Path(rcfg.getName()));
        req.setAttribute("path", (Object)lpath);
        req.setAttribute("fpath", (Object)fpath);
        lConn.withAllReaders(new LuceneConnection.ReaderActionN(){

            public void perform(IndexReader[] readers) throws IOException, DbException {
                QuickSearcher searcher = new QuickSearcher(readers, engine);
                QuickSearchResults results = searcher.search(params);
                try {
                    UrlHelper redirectUrl = results.getExactMatchRedirect();
                    if (redirectUrl != null) {
                        QuickSearchAction.this.getResponse().sendRedirect(req.getContextPath() + redirectUrl.toString());
                    } else {
                        req.setAttribute("results", (Object)results);
                        req.getRequestDispatcher("/WEB-INF/jsp/quickresults.jsp").forward((ServletRequest)req, (ServletResponse)QuickSearchAction.this.getResponse());
                    }
                }
                catch (ServletException e2) {
                    Logs.APP_LOG.warn((Object)"error in quicksearch", (Throwable)e2);
                }
            }
        });
        return null;
    }

    private QuickSearchParams setupParams(RepositoryConfig rcfg, RepositoryEngine engine, Path lpath) {
        String searchAllDirsStr;
        List filenameParams;
        HttpServletRequest req = this.getRequest();
        QuickSearchParams params = new QuickSearchParams((Analyzer)rcfg.getMasterAnalyzer(), lpath);
        params.setSearchAllDirs(true);
        StringBuffer searchString = new StringBuffer();
        List anyParams = this.split(req.getParameterValues("q"));
        if (anyParams != null) {
            for (String term : anyParams) {
                if (term.startsWith("file:")) {
                    params.addFilenameTerm(term.substring("file:".length()));
                } else {
                    params.addAny(term);
                }
                searchString.append(' ').append(term);
            }
        }
        if ((filenameParams = this.split(req.getParameterValues("filename"))) != null) {
            params.setSearchAllDirs(false);
            for (String term : filenameParams) {
                params.addFilenameTerm(term);
                searchString.append(" file:").append(term);
            }
        }
        if ((searchAllDirsStr = req.getParameter("searchAllDirs")) != null) {
            params.setSearchAllDirs("true".equals(searchAllDirsStr));
        }
        req.setAttribute("quickSearchString", (Object)searchString.toString().trim());
        return params;
    }

    private List split(String[] strings) {
        if (strings == null) {
            return null;
        }
        LinkedList<String> terms = new LinkedList<String>();
        for (int i2 = 0; i2 < strings.length; ++i2) {
            String s = strings[i2].trim();
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreTokens()) {
                String term = tokenizer.nextToken();
                terms.add(term);
            }
        }
        return terms;
    }
}

