/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class UserProfile {
    public static final int WATCH_INSTANT = 0;
    public static final int WATCH_NIGHTLY = 1;
    public static final int EMAIL_TEXT = 0;
    public static final int EMAIL_HTML = 1;
    private String username;
    private String timezone = null;
    private String cookiePrefs = "";
    private int tabwidth = AppConfig.DEFAULT_TAB_WIDTH;
    private int watchMode = 0;
    private int emailFormat = 1;
    private int changesetsPerPage = 30;
    private int maxFilesPerChangeset = 5;
    private AuthorMappings authorMappings = AuthorMappings.fromString("");
    public static final String DEFAULT = "DEFAULT_USER";

    public UserProfile() {
    }

    public UserProfile(String username) {
        this.username = username;
    }

    public UserProfile(String username, UserProfile that) {
        this.username = username;
        this.timezone = that.timezone;
        this.tabwidth = that.tabwidth;
        this.watchMode = that.watchMode;
        this.emailFormat = that.emailFormat;
        this.cookiePrefs = that.cookiePrefs;
        this.authorMappings = that.authorMappings;
        this.changesetsPerPage = that.changesetsPerPage;
        this.maxFilesPerChangeset = that.maxFilesPerChangeset;
    }

    public UserProfile(UserProfile that) {
        this(that.username, that);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = "".equals(timezone) ? null : timezone;
    }

    public int getTabwidth() {
        return this.tabwidth;
    }

    public void setTabwidth(int tabwidth) {
        this.tabwidth = tabwidth;
    }

    public String getCookiePrefs() {
        return this.cookiePrefs;
    }

    public void setCookiePrefs(String cookiePrefs) {
        this.cookiePrefs = cookiePrefs;
    }

    public int getWatchMode() {
        return this.watchMode;
    }

    public void setWatchMode(int watchMode) {
        this.watchMode = watchMode;
    }

    public int getEmailFormat() {
        return this.emailFormat;
    }

    public void setEmailFormat(int emailFormat) {
        this.emailFormat = emailFormat;
    }

    public boolean isHtmlEmailFormat() {
        return this.emailFormat == 1;
    }

    public boolean isNightlyWatchMode() {
        return this.watchMode == 1;
    }

    public int getChangesetsPerPage() {
        return this.changesetsPerPage;
    }

    public void setChangesetsPerPage(int changesetsPerPage) {
        this.changesetsPerPage = changesetsPerPage;
    }

    public int getMaxFilesPerChangeset() {
        return this.maxFilesPerChangeset;
    }

    public void setMaxFilesPerChangeset(int maxFilesPerChangeset) {
        this.maxFilesPerChangeset = maxFilesPerChangeset;
    }

    public AuthorMappings getAuthorMappings() {
        return this.authorMappings;
    }

    public void setAuthorMapping(AuthorMappings mappings) {
        this.authorMappings = mappings;
    }

    public String getEffectiveTimezone() {
        return this.getTimezone() == null ? ConfigUtil.getDefaultTimezone() : this.getTimezone();
    }

    public String toString() {
        return "UserProfile[username=" + this.username + ";tabwidth=" + this.tabwidth + ";timezone=" + this.timezone + ";watchmode=" + this.watchMode + ";emailFormat=" + this.emailFormat + "changesetsPerPage=" + this.changesetsPerPage + ";maxFilesPerChangeset=" + this.maxFilesPerChangeset + ";cookiestr=" + this.cookiePrefs + "]";
    }

    public static class AuthorMappings {
        private Map mappings;

        public AuthorMappings(Map mappings) {
            this.mappings = mappings;
        }

        public String getAuthorForRep(String rep) {
            return (String)this.mappings.get(rep);
        }

        public Set getMappedReps() {
            return this.mappings.keySet();
        }

        public void deleteMapping(String rep) {
            this.mappings.remove(rep);
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            String sep = "";
            for (String rep : this.mappings.keySet()) {
                String author = (String)this.mappings.get(rep);
                result.append(sep).append(rep).append(":").append(author);
                sep = ",";
            }
            return result.toString();
        }

        public static AuthorMappings fromString(String mapstring) {
            HashMap<String, String> mappings = new HashMap<String, String>();
            StringTokenizer toks = new StringTokenizer(mapstring, ",");
            while (toks.hasMoreTokens()) {
                String[] mapping = toks.nextToken().split(":");
                if (mapping.length != 2) continue;
                mappings.put(mapping[0], mapping[1]);
            }
            return new AuthorMappings(mappings);
        }

        public void addMapping(String rep, String author) {
            this.mappings.put(rep, author);
        }
    }
}

