/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.web.admin.actions.AbstractLinkerAction;

public abstract class AbstractAddLinkerAction
extends AbstractLinkerAction {
    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        LinkerType linker = null;
        if (this.isDefault()) {
            linker = cfg.getRepositoryDefaults().getLinker();
        } else {
            try {
                RepositoryType repository = cfg.getRepositoryArray(this.getRep());
                if (!repository.isSetLinker()) {
                    linker = LinkerType.Factory.newInstance();
                    repository.setLinker(linker);
                }
                linker = repository.getLinker();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
        }
        try {
            this.addLinker(linker);
            this.updateLinkers();
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad linker index " + this.getIdx() + ", rep=" + this.getRep());
            return "error";
        }
        return "success";
    }

    public String doDefault() throws Exception {
        return "success";
    }

    protected abstract void addLinker(LinkerType var1);
}

