/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.LinkerAdvancedType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.web.admin.actions.AbstractEditLinkerAction;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

public class EditAdvancedLinkerAction
extends AbstractEditLinkerAction {
    private LinkerAdvancedType advanced = LinkerAdvancedType.Factory.newInstance();

    public LinkerAdvancedType getAdvanced() {
        return this.advanced;
    }

    protected void loadLinker(LinkerType linker) {
        LinkerAdvancedType editing = linker.getAdvancedArray(this.getIdx());
        this.advanced.setSyntaxdef(editing.getSyntaxdef());
        if (editing.isSetDescription()) {
            this.advanced.setDescription(editing.getDescription());
        }
    }

    protected void saveLinker(LinkerType linker) {
        linker.setAdvancedArray(this.getIdx(), this.advanced);
    }

    public void validate() {
        StringReader def = new StringReader("syntaxdef validation_tmp {" + this.advanced.getSyntaxdef() + "}");
        ArrayList<String> errors = new ArrayList<String>();
        SyntaxDefinition.parse(def, errors);
        if (errors.size() > 0) {
            Iterator err = errors.iterator();
            while (err.hasNext()) {
                this.addFieldError("advanced.syntaxdef", "Error parsing syntax definition:" + (String)err.next());
            }
        }
    }
}

