/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.ResourcesType;
import com.cenqua.fisheye.rep.ping.PingManager;
import com.opensymphony.xwork.ActionSupport;

public class EditResourceLimitsAction
extends ActionSupport {
    private ResourcesType resources;

    public ResourcesType getResources() {
        if (this.resources == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            if (!cfg.isSetResources()) {
                cfg.addNewResources();
            }
            this.resources = (ResourcesType)cfg.getResources().copy();
            if (!this.resources.isSetIncrementalIndexThreads()) {
                this.resources.addNewIncrementalIndexThreads();
            }
            if (!this.resources.isSetInitialIndexThreads()) {
                this.resources.addNewInitialIndexThreads();
            }
        }
        return this.resources;
    }

    public String execute() throws Exception {
        ResourcesType editing = this.getResources();
        if (editing.getInitialIndexThreads().getMax().intValue() < 1) {
            this.addActionError("The number of threads for initial indexing cannot be less than 1.");
        }
        if (editing.getIncrementalIndexThreads().getMax().intValue() < 1) {
            this.addActionError("The number of threads for incremental indexing cannot be less than 1.");
        }
        if (!this.hasActionErrors()) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            cfg.setResources(editing);
            AppConfig.getsConfig().saveConfig();
            PingManager.setThreadConfig(editing);
        }
        return this.hasActionErrors() || this.hasActionMessages() ? "input" : "success";
    }
}

