/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SmtpType;
import com.opensymphony.xwork.ActionSupport;

public class EditSmtpConfigAction
extends ActionSupport {
    private SmtpType smtp = SmtpType.Factory.newInstance();
    private boolean debug;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public SmtpType getSmtp() {
        return this.smtp;
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        if (this.smtp.isSetPort() && this.smtp.getPort() == null) {
            this.smtp.unsetPort();
        }
        if (this.smtp.isSetUsername() && EditSmtpConfigAction.nullOrEmpty(this.smtp.getUsername())) {
            this.smtp.unsetUsername();
        }
        if (this.smtp.isSetPassword() && EditSmtpConfigAction.nullOrEmpty(this.smtp.getPassword())) {
            this.smtp.unsetPassword();
        }
        this.smtp.setDebug(this.debug);
        cfg.setSmtp(this.smtp);
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().getMailer().reload(this.smtp);
        return "success";
    }

    public String deleteConfig() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        if (cfg.isSetSmtp()) {
            cfg.unsetSmtp();
        }
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().getMailer().reload(null);
        return "success";
    }

    public String doDefault() throws Exception {
        if (this.getCfg().isSetSmtp()) {
            this.smtp = (SmtpType)this.getCfg().getSmtp().copy();
            this.debug = this.smtp.isSetDebug() && this.smtp.getDebug();
        }
        return "success";
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

