/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CustomRepositoryConfigType;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.config1.HostAuthRepositoryConfigType;
import com.cenqua.fisheye.config1.LdapRepositoryConfigType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepSecurityEditAction
extends BaseRepositoryAction {
    private int allowAnon;
    private String matchType;
    private String ldapFilter;
    private String requiredGroup;
    private String repname;
    private String customRestriction;
    private String cancel;
    private String leave;
    private String join;
    private List<String> addGroups;
    private List<String> deleteGroups;
    private List<String> groupsCache;

    @Override
    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public String getCustomRestriction() {
        return this.customRestriction;
    }

    public void setCustomRestriction(String customRestriction) {
        this.customRestriction = customRestriction;
    }

    public String getRepname() {
        return this.repname;
    }

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public int getAllowAnon() {
        return this.allowAnon;
    }

    public void setAllowAnon(int allowAnon) {
        this.allowAnon = allowAnon;
    }

    public String getLdapFilter() {
        return this.ldapFilter;
    }

    public void setLdapFilter(String ldapFilter) {
        this.ldapFilter = ldapFilter;
    }

    public String getRequiredGroup() {
        return this.requiredGroup;
    }

    public void setRequiredGroup(String requiredGroup) {
        this.requiredGroup = requiredGroup;
    }

    public String getMatchType() {
        return this.matchType;
    }

    public List<String> getGroupsCache() {
        if (this.groupsCache == null) {
            this.groupsCache = this.getAssignedGroups();
        }
        return this.groupsCache;
    }

    public void setGroupsCache(List<String> groupsCache) {
        this.groupsCache = groupsCache;
    }

    public void setGroupsCacheEmpty(boolean groupsCacheEmpty) {
        this.groupsCache = new ArrayList<String>();
    }

    public void setMatchType(String matchType) {
        this.matchType = matchType;
    }

    public void setAddGroups(List<String> addGroups) {
        this.addGroups = addGroups;
    }

    public void setDeleteGroups(List<String> deleteGroups) {
        this.deleteGroups = deleteGroups;
    }

    public void setJoin(String join) {
        this.join = join;
    }

    public void setLeave(String leave) {
        this.leave = leave;
    }

    public List<String> getAvailableGroups() {
        LinkedList<String> availableGroups = new LinkedList<String>(this.getGroupNames());
        availableGroups.removeAll(this.getGroupsCache());
        return availableGroups;
    }

    private List<String> getAssignedGroups() {
        if (this.isDefault()) {
            return this.getDefaultAssignedGroups();
        }
        return this.getRepositoryHandle().getCfg().getAllowedGroups();
    }

    private List<String> getDefaultAssignedGroups() {
        LinkedList<String> groups = new LinkedList<String>();
        GroupType[] groupElements = this.getCfg().getRepositoryDefaults().getSecurity().getRequiredGroups().getGroupArray();
        if (groupElements.length > 0) {
            GroupType[] types;
            for (GroupType type : types = this.getCfg().getRepositoryDefaults().getSecurity().getRequiredGroups().getGroupArray()) {
                groups.add(type.getName());
            }
        }
        return groups;
    }

    private RepSecurityType load() {
        RepSecurityType sec;
        ConfigDocument.Config cfg = this.getCfg();
        if (this.isDefault()) {
            sec = cfg.getRepositoryDefaults().getSecurity();
        } else {
            try {
                RepositoryType rep = cfg.getRepositoryArray(this.getRep());
                sec = rep.getSecurity();
                this.repname = rep.getName();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return null;
            }
        }
        return sec;
    }

    private void setup(RepSecurityType sec) {
        this.allowAnon = sec.isSetAllowAnon() ? (sec.getAllowAnon() ? 1 : 0) : 2;
        if (sec.isSetLdap()) {
            this.ldapFilter = sec.getLdap().getFilter();
            this.matchType = sec.getLdap().getMatchType();
        }
        if (sec.isSetHostAuth()) {
            this.requiredGroup = sec.getHostAuth().getRequiredGroup();
        }
        if (sec.isSetCustom()) {
            this.customRestriction = sec.getCustom().getConstraint();
        }
    }

    public String doDefault() throws Exception {
        RepSecurityType sec = this.load();
        if (this.hasErrors()) {
            return "error";
        }
        this.setup(sec);
        return "success";
    }

    public String execute() throws Exception {
        if (this.cancel != null) {
            return "success";
        }
        if (this.join != null) {
            if (this.addGroups != null) {
                this.getGroupsCache().addAll(this.addGroups);
            }
            return "input";
        }
        if (this.leave != null) {
            if (this.deleteGroups != null) {
                this.getGroupsCache().removeAll(this.deleteGroups);
            }
            return "input";
        }
        this.storeGroups();
        RepSecurityType sec = this.load();
        if (this.hasErrors()) {
            return "error";
        }
        if (this.allowAnon == 2) {
            if (sec.isSetAllowAnon()) {
                sec.unsetAllowAnon();
            }
        } else {
            sec.setAllowAnon(this.allowAnon == 1);
        }
        if (this.ldapFilter == null || "".equals(this.ldapFilter)) {
            if (sec.isSetLdap()) {
                sec.unsetLdap();
            }
        } else {
            LdapRepositoryConfigType ldap = sec.getLdap();
            if (ldap == null) {
                ldap = sec.addNewLdap();
            }
            ldap.setFilter(this.ldapFilter);
            ldap.setMatchType(this.matchType);
        }
        if (this.requiredGroup == null || "".equals(this.requiredGroup)) {
            if (sec.isSetHostAuth()) {
                sec.unsetHostAuth();
            }
        } else {
            HostAuthRepositoryConfigType hostauth = sec.getHostAuth();
            if (hostauth == null) {
                hostauth = sec.addNewHostAuth();
            }
            hostauth.setRequiredGroup(this.requiredGroup);
        }
        if (this.customRestriction == null || "".equals(this.customRestriction)) {
            if (sec.isSetCustom()) {
                sec.unsetCustom();
            }
        } else {
            CustomRepositoryConfigType custom = sec.getCustom();
            if (custom == null) {
                custom = sec.addNewCustom();
            }
            custom.setConstraint(this.customRestriction);
        }
        this.saveCfg();
        return "success";
    }

    private void storeGroups() {
        GroupListType groupList = GroupListType.Factory.newInstance();
        for (String group : this.getGroupsCache()) {
            groupList.addNewGroup().setName(group);
        }
        if (this.isDefault()) {
            this.getCfg().getRepositoryDefaults().getSecurity().setRequiredGroups(groupList);
        } else {
            this.getCfg().getRepositoryArray(this.getRep()).getSecurity().setRequiredGroups(groupList);
        }
        try {
            this.saveCfg();
        }
        catch (IOException e2) {
            this.addActionError("Error saving config file: " + e2);
        }
    }
}

