/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAdminAction
extends BaseAdminAction {
    private static final int MAX_PER_PAGE = 30;
    private final UserManager um = UserAdminAction.getUserManager();
    private List<FEUser> displayUsers = new LinkedList<FEUser>();
    private String filterGroup;
    private String filterEmail;
    private int totalMatching;
    private int totalUsers;
    private int pageStartRow;

    public List<Page> getNextPrevPages() {
        int maxPagesEitherSide = 10;
        int start = Math.max(0, this.pageStartRow - maxPagesEitherSide * 30);
        int startPageNum = start / 30 + 1;
        int currentPageNum = this.pageStartRow / 30 + 1;
        int end = Math.min(this.totalMatching, this.pageStartRow + maxPagesEitherSide * 30);
        LinkedList<Page> pages = new LinkedList<Page>();
        int row = start;
        int num = startPageNum;
        while (row < end) {
            pages.add(new Page(num, row, num == currentPageNum));
            row += 30;
            ++num;
        }
        return pages;
    }

    public int getRowsPerPage() {
        return 30;
    }

    public int getPageEndRow() {
        return this.getPageStartRow() + this.displayUsers.size();
    }

    public int getPageStartRow() {
        return this.pageStartRow;
    }

    public void setPageStartRow(int pageStartRow) {
        this.pageStartRow = pageStartRow;
    }

    public int getTotalMatching() {
        return this.totalMatching;
    }

    public int getTotalUsers() {
        return this.totalUsers;
    }

    public String getFilterGroup() {
        return this.filterGroup;
    }

    public void setFilterGroup(String filterGroup) {
        this.filterGroup = filterGroup;
    }

    public String getFilterEmail() {
        return this.filterEmail;
    }

    public void setFilterEmail(String filterEmail) {
        this.filterEmail = filterEmail;
    }

    public Map getAuthTypes() {
        return FEUser.AUTH_NAMES;
    }

    public String execute() throws Exception {
        this.totalUsers = this.um.getUserCount();
        List<String> usernames = !StringUtil.nullOrEmpty(this.filterGroup) ? this.um.getUsersInGroup(this.filterGroup) : this.um.getAllUsernames();
        this.totalUsers = usernames.size();
        for (String uname : usernames) {
            FEUser user = this.um.getUser(uname);
            if (!this.matchesFilter(user)) continue;
            if (this.pageStartRow <= this.totalMatching && this.displayUsers.size() < 30) {
                this.displayUsers.add(user);
            }
            ++this.totalMatching;
        }
        return "success";
    }

    public boolean isNoUsersConfigured() {
        return this.totalUsers == 0;
    }

    public List<FEUser> getDisplayUsers() {
        return this.displayUsers;
    }

    private boolean matchesFilter(FEUser user) {
        String email;
        return StringUtil.nullOrEmpty(this.filterEmail) || (email = user.getEmail()) != null && email.indexOf(this.filterEmail) != -1;
    }

    public static class Page {
        private final int num;
        private final int start;
        private final boolean current;

        public Page(int num, int start, boolean current) {
            this.num = num;
            this.start = start;
            this.current = current;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public int getNum() {
            return this.num;
        }

        public int getStart() {
            return this.start;
        }
    }
}

