/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.api;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.ParseUtil;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.api.BaseRepositoryAction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class ConfigAction
extends BaseRepositoryAction {
    private final String ROOT_PATH = "/";
    private final String REP_DEFAULTS_PATH = "/repository-defaults";
    private final String REP_DEFAULTS_SECURITY_PATH = "/repository-defaults/security";
    private final Pattern REP_PROG = Pattern.compile("^/repository/([^/]+)$");
    private final Pattern REP_SECURITY_PROG = Pattern.compile("^/repository/([^/]+)/security");

    public String doGet() throws IOException {
        String repname;
        RepositoryType rep;
        ConfigDocument config = AppConfig.getsConfig().getConfigDocument();
        String select = this.getActionPathInfo();
        if ("/".equals(select = ConfigAction.cleanSelect(select))) {
            return this.send(config);
        }
        if ("/repository-defaults".equals(select)) {
            return this.send(config.getConfig().getRepositoryDefaults());
        }
        if ("/repository-defaults/security".equals(select)) {
            return this.send(config.getConfig().getRepositoryDefaults().getSecurity());
        }
        Matcher m = this.REP_PROG.matcher(select);
        if (m.matches() && (rep = this.getRepository(config, repname = m.group(1))) != null) {
            return this.send(rep);
        }
        m = this.REP_SECURITY_PROG.matcher(select);
        if (m.matches() && (rep = this.getRepository(config, repname = m.group(1))) != null) {
            return this.send(rep.getSecurity());
        }
        return "notfound";
    }

    public String doPut() throws Exception {
        ConfigDocument config = AppConfig.getsConfig().getConfigDocument();
        String select = this.getActionPathInfo();
        if ("/repository-defaults".equals(select = ConfigAction.cleanSelect(select))) {
            RepositoryDefaultsType defaults = ParseUtil.parseRepositoryDefaults(this.getBodyAsString());
            return this.update(config, defaults);
        }
        if ("/repository-defaults/security".equals(select)) {
            RepSecurityType sec = ParseUtil.parseRepositorySecurity(this.getBodyAsString());
            return this.update(config, sec);
        }
        Matcher m = this.REP_SECURITY_PROG.matcher(select);
        if (m.matches()) {
            String repname = m.group(1);
            RepSecurityType sec = ParseUtil.parseRepositorySecurity(this.getBodyAsString());
            return this.update(config, repname, sec);
        }
        m = this.REP_PROG.matcher(select);
        if (m.matches()) {
            String repname = m.group(1);
            RepositoryType body = ParseUtil.parseRepository(this.getBodyAsString());
            if (!body.getName().equals(repname)) {
                Logs.APP_LOG.info((Object)"Repository name in url and body do not match");
                return "notfound";
            }
            RepositoryType rep = this.getRepository(config, repname);
            if (rep != null) {
                return this.update(config, rep, body);
            }
            return this.add(config, body);
        }
        return "notfound";
    }

    public String doDelete() throws Exception {
        ConfigDocument config = AppConfig.getsConfig().getConfigDocument();
        String select = this.getActionPathInfo();
        Matcher m = this.REP_PROG.matcher(select = ConfigAction.cleanSelect(select));
        if (m.matches()) {
            String repname = m.group(1);
            return this.delete(config, repname);
        }
        return "notfound";
    }

    private String delete(ConfigDocument config, String repname) throws Exception {
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        RepositoryHandle rh = rm.getRepository(repname);
        if (rh == null) {
            return "notfound";
        }
        if (!rh.isStopped()) {
            Logs.APP_LOG.warn((Object)"Repository needs to be stopped");
            return "notfound";
        }
        RepositoryType[] reps = config.getConfig().getRepositoryArray();
        for (int i2 = 0; i2 < reps.length; ++i2) {
            RepositoryType rep = reps[i2];
            if (!rep.getName().equals(repname)) continue;
            config.getConfig().removeRepository(i2);
            break;
        }
        AppConfig.getsConfig().saveConfig();
        rm.reloadList();
        return "success";
    }

    private String add(ConfigDocument config, RepositoryType newRep) throws IOException, ConfigException {
        int idx = config.getConfig().sizeOfRepositoryArray();
        config.getConfig().insertNewRepository(idx);
        config.getConfig().setRepositoryArray(idx, newRep);
        AppConfig.getsConfig().saveConfig();
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        rm.reloadList();
        return this.send(newRep);
    }

    private String update(ConfigDocument config, RepositoryType old, RepositoryType newRep) throws IOException {
        String repname = old.getName();
        RepositoryHandle h2 = AppConfig.getsConfig().getRepositoryManager().getRepository(repname);
        if (!h2.isStopped()) {
            Logs.APP_LOG.warn((Object)"Repository needs to be stopped");
            return "notfound";
        }
        RepositoryType[] reps = config.getConfig().getRepositoryArray();
        for (int i2 = 0; i2 < reps.length; ++i2) {
            RepositoryType rep = reps[i2];
            if (!rep.getName().equals(repname)) continue;
            config.getConfig().setRepositoryArray(i2, newRep);
            break;
        }
        AppConfig.getsConfig().saveConfig();
        return this.send(newRep);
    }

    private String update(ConfigDocument config, String repname, RepSecurityType sec) throws IOException {
        RepositoryType[] reps;
        for (RepositoryType rep : reps = config.getConfig().getRepositoryArray()) {
            if (!rep.getName().equals(repname)) continue;
            rep.setSecurity(sec);
            AppConfig.getsConfig().saveConfig();
            return this.send(rep.getSecurity());
        }
        return "notfound";
    }

    private String update(ConfigDocument config, RepositoryDefaultsType newDefaults) throws IOException {
        config.getConfig().setRepositoryDefaults(newDefaults);
        AppConfig.getsConfig().saveConfig();
        return this.send(config.getConfig().getRepositoryDefaults());
    }

    private String update(ConfigDocument config, RepSecurityType sec) throws IOException {
        config.getConfig().getRepositoryDefaults().setSecurity(sec);
        AppConfig.getsConfig().saveConfig();
        return this.send(config.getConfig().getRepositoryDefaults().getSecurity());
    }

    private RepositoryType getRepository(ConfigDocument config, String repname) {
        RepositoryType[] repositories;
        for (RepositoryType rep : repositories = config.getConfig().getRepositoryArray()) {
            if (!rep.getName().equals(repname)) continue;
            return rep;
        }
        return null;
    }

    private String send(XmlObject xml) throws IOException {
        this.contentType = "text/xml";
        StringWriter out = new StringWriter();
        XmlOptions opts = new XmlOptions();
        opts.setSaveImplicitNamespaces(RootConfig.makeExplicitNamespaces());
        opts.setSaveOuter();
        xml.save((Writer)out, opts);
        this.resultBody = out.toString();
        return "success";
    }

    protected static String cleanSelect(String select) {
        if (StringUtil.nullOrEmpty(select)) {
            select = "/";
        }
        if (!select.startsWith("/")) {
            select = "/" + select;
        }
        return select;
    }
}

