/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.api;

import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.web.admin.api.BaseRepositoryAction;

public class RepositoryStateAction
extends BaseRepositoryAction {
    public String doPut() throws Exception {
        if (this.repname == null) {
            return "notfound";
        }
        RepositoryManager rm = this.getRepositoryManager();
        RepositoryHandle handle = rm.getRepository(this.repname);
        if (handle == null) {
            return "notfound";
        }
        String command = this.getBodyAsString();
        if ("STOPPED".equalsIgnoreCase(command)) {
            handle.stop();
        } else if ("RUNNING".equalsIgnoreCase(command)) {
            try {
                rm.runRepository(this.repname);
            }
            catch (RepositoryHandle.StateException e2) {
                Logs.APP_LOG.info((Object)"Could not change state, continuing");
            }
        }
        this.resultBody = handle.getStateDescription().toUpperCase();
        return "success";
    }

    public String doGet() {
        if (this.repname == null) {
            return "notfound";
        }
        RepositoryManager rm = this.getRepositoryManager();
        RepositoryHandle handle = rm.getRepository(this.repname);
        if (handle == null) {
            return "notfound";
        }
        this.resultBody = handle.getStateDescription().toUpperCase();
        return "success";
    }
}

