/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.interceptors;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import java.util.Map;

public class LoginInterceptor
extends AroundInterceptor {
    public static final String SESSION_KEY = LoginInterceptor.class.getName() + ".user";
    public static final String SUCCESS_URL_KEY = LoginInterceptor.class.getName() + ".url";
    private boolean loggedIn = false;

    protected void after(ActionInvocation actionInvocation, String s) throws Exception {
    }

    protected void before(ActionInvocation actionInvocation) throws Exception {
        ActionContext ctx = ActionContext.getContext();
        Map session = ctx.getSession();
        Object user = session.get(SESSION_KEY);
        if (user != null) {
            this.loggedIn = true;
            return;
        }
        this.loggedIn = false;
        StringBuffer successURL = ServletActionContext.getRequest().getRequestURL();
        String query = ServletActionContext.getRequest().getQueryString();
        if (query != null) {
            successURL.append("?" + query);
        }
        session.put(SUCCESS_URL_KEY, successURL.toString());
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        this.before(invocation);
        if (!this.loggedIn) {
            return "login";
        }
        return invocation.invoke();
    }
}

