/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.setup;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.license.CenquaLicenseWrapper;
import com.cenqua.fisheye.license.CrucibleLicense;
import com.cenqua.fisheye.license.FishEyeLicense;
import com.cenqua.fisheye.license.LicenseException;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.license.CenquaLicense;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SetupServlet
extends HttpServlet {
    private static final String PASSWORD_1 = "password";
    private static final String PASSWORD_2 = "password2";
    private static final String NEW_PASSWORDS = "showpasswords";
    private static final String ERR_PASSWORDS = "pwerr";
    private static final String ERR_AUTH = "autherr";
    private static final String FE_LICENSE = "felicense";
    private static final String SHOW_FE_LICENSE = "showfelic";
    private static final String ERR_FE_LICENSE = "feerr";
    private static final String CRU_LICENSE = "crulicense";
    private static final String SHOW_CRU_LICENSE = "showcrulic";
    private static final String ERR_CRU_LICENSE = "cruerr";
    private static final String INITIAL_VIEW_SHOWN = "passedfirst";
    private static final String FE_LICENSE_FILENAME = "fisheye.license";
    private static final String CRU_LICENSE_FILENAME = "crucible.license";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RootConfig cfg = AppConfig.getsConfig();
        SetupState state = new SetupState();
        if (this.adminPasswordNotSet(cfg)) {
            this.inputOrVerifyNewAdminPassword(cfg, state, req);
        } else {
            this.inputOrAuthenticateAdminPassword(state, req);
        }
        this.inputOrValidateFishEyeLicense(cfg, state, req);
        if (AppConfig.isCrucible()) {
            this.inputOrValidateCrucibleLicense(cfg, state, req);
        }
        if (state.authenticated && state.validSetup) {
            resp.sendRedirect(req.getContextPath() + "/admin/");
            return;
        }
        req.setAttribute(INITIAL_VIEW_SHOWN, (Object)"true");
        if (state.passwordUpdated || state.licenseUpdated) {
            try {
                cfg.saveConfig();
            }
            catch (IOException e2) {
                if (state.passwordUpdated) {
                    cfg.getAdminConfig().updateAdminPassword(null);
                }
                this.showUpdateError(e2, "error saving config", "Could not save configuration, please ensure that the config file is writeable: " + e2, req, resp);
                return;
            }
            if (state.licenseUpdated) {
                try {
                    cfg.loadLicense();
                    cfg.getUserManager().notifyLicenseUpdate();
                    cfg.startRepositories();
                }
                catch (LicenseException e3) {
                    this.showUpdateError(e3, "error loading license from stored config", "Could not read from saved configuration: " + e3.getMessage(), req, resp);
                    return;
                }
            }
        }
        if (this.setupSuccessful(cfg)) {
            req.getRequestDispatcher("/WEB-INF/jsp/setup/done.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        } else {
            this.setupMessages(cfg, req);
            req.getRequestDispatcher("/WEB-INF/jsp/setup/index.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        }
    }

    private void inputOrValidateCrucibleLicense(RootConfig cfg, SetupState state, HttpServletRequest req) {
        CrucibleLicense crucibleLicense;
        CrucibleLicense crucibleLicense2 = crucibleLicense = cfg.getLicense() == null ? null : cfg.getLicense().getCrucibleLicense();
        if (this.licenseMissingOrTerminated(crucibleLicense)) {
            state.validSetup = false;
            String license = this.readInput(req, CRU_LICENSE);
            boolean noInput = StringUtil.nullOrEmpty(license);
            if (noInput && cfg.getConfig().getLicense().isSetCrucible()) {
                if (!this.validateLicenseString(cfg.getConfig().getLicense().getCrucible(), true, LicenseSource.CONFIG_XML, req)) {
                    req.setAttribute(SHOW_CRU_LICENSE, (Object)"true");
                }
            } else if (noInput && this.getLicenseFile(CRU_LICENSE_FILENAME, cfg) != null) {
                if (!this.validateLicenseFile(this.getLicenseFile(CRU_LICENSE_FILENAME, cfg), true, LicenseSource.FILE, req)) {
                    req.setAttribute(SHOW_CRU_LICENSE, (Object)"true");
                }
            } else if (state.authenticated && this.validateLicenseString(license, true, LicenseSource.USER_INPUT, req)) {
                cfg.getConfig().getLicense().setCrucible(license);
                state.licenseUpdated = true;
            } else {
                req.setAttribute(SHOW_CRU_LICENSE, (Object)"true");
                req.setAttribute(CRU_LICENSE, (Object)license);
            }
        }
    }

    private void inputOrValidateFishEyeLicense(RootConfig cfg, SetupState state, HttpServletRequest req) {
        FishEyeLicense fisheyeLicense;
        FishEyeLicense fishEyeLicense = fisheyeLicense = cfg.getLicense() == null ? null : cfg.getLicense().getFisheyeLicense();
        if (this.licenseMissingOrTerminated(fisheyeLicense)) {
            state.validSetup = false;
            String license = this.readInput(req, FE_LICENSE);
            boolean noInput = StringUtil.nullOrEmpty(license);
            if (noInput && cfg.getConfig().getLicense().isSetFisheye()) {
                if (!this.validateLicenseString(cfg.getConfig().getLicense().getFisheye(), false, LicenseSource.CONFIG_XML, req)) {
                    req.setAttribute(SHOW_FE_LICENSE, (Object)"true");
                }
            } else if (noInput && this.getLicenseFile(FE_LICENSE_FILENAME, cfg) != null) {
                if (!this.validateLicenseFile(this.getLicenseFile(FE_LICENSE_FILENAME, cfg), false, LicenseSource.FILE, req)) {
                    req.setAttribute(SHOW_FE_LICENSE, (Object)"true");
                }
            } else if (state.authenticated && this.validateLicenseString(license, false, LicenseSource.USER_INPUT, req)) {
                cfg.getConfig().getLicense().setFisheye(license);
                state.licenseUpdated = true;
            } else {
                req.setAttribute(SHOW_FE_LICENSE, (Object)"true");
                req.setAttribute(FE_LICENSE, (Object)license);
            }
        }
    }

    private File getLicenseFile(String filename, RootConfig cfg) {
        File feLicenseFile = new File(AppConfig.getInstanceDir(), filename);
        if (feLicenseFile.exists()) {
            return feLicenseFile;
        }
        return null;
    }

    private void inputOrAuthenticateAdminPassword(SetupState state, HttpServletRequest req) {
        AdminConfig admin = AppConfig.getsConfig().getAdminConfig();
        String password = this.readInput(req, "adminPassword");
        if (!this.isFirstView(req)) {
            if (StringUtil.nullOrEmpty(password)) {
                req.setAttribute(ERR_AUTH, (Object)"Please enter a password");
            } else if (!admin.verifyAdminPassword(password)) {
                req.setAttribute(ERR_AUTH, (Object)"Password incorrect");
            } else {
                state.authenticated = true;
            }
        }
    }

    private void inputOrVerifyNewAdminPassword(RootConfig cfg, SetupState state, HttpServletRequest req) {
        state.validSetup = false;
        if (this.isFirstView(req)) {
            req.setAttribute(NEW_PASSWORDS, (Object)"true");
        } else {
            String p2;
            String p1 = this.readInput(req, PASSWORD_1);
            if (this.validatePasswordStrings(p1, p2 = this.readInput(req, PASSWORD_2), req)) {
                cfg.getAdminConfig().updateAdminPassword(p1);
                state.passwordUpdated = true;
                state.authenticated = true;
            } else {
                req.setAttribute(NEW_PASSWORDS, (Object)"true");
            }
        }
    }

    protected boolean validateLicenseFile(File license, boolean isCrucibleLicense, LicenseSource src, HttpServletRequest req) {
        LicenseHolder licenseHolder = new LicenseHolder();
        if (isCrucibleLicense) {
            licenseHolder.setCruLicenseFile(license);
        } else {
            licenseHolder.setFeLicenseFile(license);
        }
        return this.validateLicense(licenseHolder, isCrucibleLicense, src, req);
    }

    protected boolean validateLicenseString(String license, boolean isCrucibleLicense, LicenseSource src, HttpServletRequest req) {
        LicenseHolder licenseHolder = this.constructSingleLicenseHolder(license, isCrucibleLicense);
        return this.validateLicense(licenseHolder, isCrucibleLicense, src, req);
    }

    protected boolean validateLicense(LicenseHolder licenseHolder, boolean isCrucibleLicense, LicenseSource src, HttpServletRequest req) {
        String sourceText;
        if (isCrucibleLicense ? !licenseHolder.hasCrucible() : !licenseHolder.hasFishEye()) {
            if (!this.isFirstView(req)) {
                this.showLicenseError(req, isCrucibleLicense, "Please enter a license key.");
            }
            return false;
        }
        switch (src) {
            case CONFIG_XML: {
                sourceText = "specified in your config.xml";
                break;
            }
            case FILE: {
                sourceText = "specified in your license file";
                break;
            }
            default: {
                sourceText = "you have entered";
            }
        }
        if (isCrucibleLicense ? !licenseHolder.canDecodeCrucible() : !licenseHolder.canDecodeFishEye()) {
            this.showLicenseError(req, isCrucibleLicense, "The license key " + sourceText + " is invalid. See log for details.");
            return false;
        }
        if (isCrucibleLicense ? licenseHolder.isCrucibleTerminated() : licenseHolder.isFishEyeTerminated()) {
            this.showLicenseError(req, isCrucibleLicense, "The license key " + sourceText + " terminated on " + new SimpleDateFormat("MMMM dd, yyyy").format(isCrucibleLicense ? licenseHolder.getCrucibleLicense().getSoftExpiry() : licenseHolder.getFishEyeLicense().getSoftExpiry()) + ". Please enter a current license key.");
            return false;
        }
        if (isCrucibleLicense ? !licenseHolder.isCrucibleValidForCurrentBuild() : !licenseHolder.isFishEyeValidForCurrentBuild()) {
            CenquaLicenseWrapper licenseWrapper = isCrucibleLicense ? licenseHolder.getCrucibleLicense() : licenseHolder.getFishEyeLicense();
            this.showLicenseError(req, isCrucibleLicense, licenseWrapper.getInvalidBuildMessage());
            return false;
        }
        return true;
    }

    protected LicenseHolder constructSingleLicenseHolder(String license, boolean isCrucibleLicense) {
        if (isCrucibleLicense) {
            return new LicenseHolder(null, license);
        }
        return new LicenseHolder(license, null);
    }

    protected boolean validatePasswordStrings(String p1, String p2, HttpServletRequest req) {
        if (p1 == null) {
            this.showPasswordError(req, "Please enter an administration password for this FishEye instance.");
            return false;
        }
        if (!p1.equals(p2)) {
            this.showPasswordError(req, "The passwords don't match.");
            return false;
        }
        if (p1.length() < 4) {
            this.showPasswordError(req, "The password should be at least 4 characters.");
            return false;
        }
        return true;
    }

    protected void showPasswordError(HttpServletRequest req, String message) {
        req.setAttribute(ERR_PASSWORDS, (Object)message);
    }

    protected boolean isFirstView(HttpServletRequest req) {
        String initialViewShown = this.readInput(req, INITIAL_VIEW_SHOWN);
        return initialViewShown == null || initialViewShown.toLowerCase().equals("false");
    }

    private String readInput(HttpServletRequest req, String field) {
        String value = req.getParameter(field);
        if (StringUtil.nullOrEmpty(value)) {
            return null;
        }
        return value.trim();
    }

    private boolean adminPasswordNotSet(RootConfig cfg) {
        return !cfg.getAdminConfig().haveDoneInitialSetup();
    }

    private boolean licenseMissingOrTerminated(CenquaLicense license) {
        return license == null || license.isTerminated();
    }

    private boolean setupSuccessful(RootConfig cfg) {
        if (cfg.getLicense() == null) {
            return false;
        }
        if (this.licenseMissingOrTerminated(cfg.getLicense().getFisheyeLicense())) {
            return false;
        }
        if (AppConfig.isCrucible() && this.licenseMissingOrTerminated(cfg.getLicense().getCrucibleLicense())) {
            return false;
        }
        return !this.adminPasswordNotSet(cfg);
    }

    private void setupMessages(RootConfig cfg, HttpServletRequest req) {
        LicenseType licenses = cfg.getConfig().isSetLicense() ? cfg.getConfig().getLicense() : null;
        LicenseHolder holder = new LicenseHolder();
        if (licenses != null && licenses.isSetFisheye()) {
            holder.setFishEyeLicenseString(licenses.getFisheye());
        } else {
            File fileFishEyeLicense = this.getLicenseFile(FE_LICENSE_FILENAME, cfg);
            if (fileFishEyeLicense != null) {
                holder.setFeLicenseFile(fileFishEyeLicense);
            }
        }
        if (licenses != null && licenses.isSetCrucible()) {
            holder.setCrucibleLicenseString(licenses.getCrucible());
        } else {
            File fileCrucibleLicense = this.getLicenseFile(CRU_LICENSE_FILENAME, cfg);
            if (fileCrucibleLicense != null) {
                holder.setCruLicenseFile(fileCrucibleLicense);
            }
        }
        if (holder.hasFishEye() && holder.canDecodeFishEye()) {
            if (holder.isFishEyeTerminated()) {
                req.setAttribute("feTerminated", (Object)"true");
            } else if (!holder.isFishEyeValidForCurrentBuild()) {
                req.setAttribute("feMissing", (Object)"true");
            }
        } else if (cfg.getLicense() == null || cfg.getLicense().getFisheyeLicense() == null) {
            req.setAttribute("feMissing", (Object)"true");
        }
        if (AppConfig.isCrucible()) {
            if (holder.hasCrucible() && holder.canDecodeCrucible()) {
                if (holder.isCrucibleTerminated()) {
                    req.setAttribute("cruTerminated", (Object)"true");
                } else if (!holder.isCrucibleValidForCurrentBuild()) {
                    req.setAttribute("cruMissing", (Object)"true");
                }
            } else if (cfg.getLicense() == null || cfg.getLicense().getCrucibleLicense() == null) {
                req.setAttribute("cruMissing", (Object)"true");
            }
        }
    }

    protected void showLicenseError(HttpServletRequest req, boolean isCrucibleLicense, String msg) {
        req.setAttribute(isCrucibleLicense ? ERR_CRU_LICENSE : ERR_FE_LICENSE, (Object)msg);
    }

    private void showUpdateError(Exception e2, String log, String msg, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Logs.APP_LOG.warn((Object)log, (Throwable)e2);
        req.setAttribute(ERR_PASSWORDS, (Object)msg);
        req.getRequestDispatcher("/WEB-INF/jsp/setup/index.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    private static class SetupState {
        boolean validSetup = true;
        boolean authenticated = false;
        boolean passwordUpdated = false;
        boolean licenseUpdated = false;

        private SetupState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LicenseSource {
        USER_INPUT,
        CONFIG_XML,
        FILE;

    }
}

