/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tags;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class RelativePathTag
extends SimpleTagSupport {
    private Path mPath = null;
    private Path mParent = null;
    private int mMaxLength = 100;
    private boolean caseSensitive = true;

    public void setMaxLength(int maxLength) {
        this.mMaxLength = maxLength;
    }

    public void setPath(Path aPath) {
        this.mPath = aPath;
    }

    public void setPrefix(Path p) {
        this.mParent = p;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void doTag() throws JspException, IOException {
        Path path = RelativePathTag.relativePath(this.mParent, this.mPath, this.caseSensitive).abbreviate(this.mMaxLength);
        String str = path.getPath();
        ExpressionUtil.escapeString(str, (Writer)this.getJspContext().getOut());
    }

    public static Path relativePath(Path parent, Path path, boolean caseSensitive) {
        if (parent.isRoot()) {
            return path;
        }
        Path rel = path.getRelativePath(parent, caseSensitive);
        if (rel.isAbove()) {
            return rel;
        }
        return new Path("./" + rel.getPath());
    }
}

