/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.themer;

import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.tags.AbstractRegionListTag;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collections;

public class BriefCheckinCommentTag
extends AbstractRegionListTag {
    private String mComment;
    private int mMaxHeight = -1;
    private int mMaxCharacters = -1;
    private boolean mWasTruncated = false;
    private String mEllipses = "&#8230;";
    private boolean mAutoCommentFormatting = true;

    public BriefCheckinCommentTag() {
        this.setPrintFirstSpaceAsSpace(true);
    }

    public void setAutoCommentFormatting(boolean autoCommentFormatting) {
        this.mAutoCommentFormatting = autoCommentFormatting;
    }

    public void setComment(String comment) {
        this.mComment = comment;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.mMaxCharacters = maxCharacters;
    }

    public void setLineSeparator(String lineSeparator) {
        this.setEol(lineSeparator);
    }

    public void setEllipses(String ellipses) {
        this.mEllipses = ellipses;
    }

    public void setMaxHeight(int maxHeight) {
        this.mMaxHeight = maxHeight;
    }

    public void doTag() throws IOException {
        RegionList regions = new RegionList();
        if (this.mAutoCommentFormatting) {
            regions.add(new Region(0, this.mComment.length(), Collections.singletonMap("findlinks", "true")));
            RepositoryConfig cfg = this.getRepositoryConfig();
            if (cfg != null) {
                cfg.getLinker().insertLinks(this.mComment, regions);
            }
        }
        Writer out = this.getOut();
        if (this.mComment.length() == 0) {
            out.write("<i>no comment</i>");
            return;
        }
        String comment = this.mComment;
        comment = this.trimToConstraint(comment);
        this.outputRegion(comment, regions, 0, comment.length());
        if (this.mWasTruncated) {
            out.write(this.mEllipses);
        }
    }

    protected RepositoryConfig getRepositoryConfig() {
        return (RepositoryConfig)this.getJspContext().findAttribute("RepositoryConfig");
    }

    private String trimToConstraint(String comment) throws IOException {
        if (this.mMaxHeight > 0) {
            String line;
            int nlines = 0;
            int end = 0;
            ReaderLineReader lines = new ReaderLineReader(new StringReader(this.mComment));
            while (null != (line = lines.readLine())) {
                if (++nlines > this.mMaxHeight) {
                    comment = comment.substring(0, end);
                    this.mWasTruncated = true;
                    break;
                }
                end += line.length();
            }
        }
        if (this.mMaxCharacters > 0 && comment.length() > this.mMaxCharacters) {
            comment = comment.substring(0, this.mMaxCharacters);
            this.mWasTruncated = true;
        }
        if (this.mWasTruncated) {
            comment = StringUtil.stripEOL(comment);
        }
        return comment;
    }

    protected String getSpanClass(Region region) {
        return null;
    }
}

