/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RepositoryUtil {
    public static List repositories(HttpServletRequest request) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(request);
        List<RepositoryHandle> handles = AppConfig.getsConfig().getRepositoryManager().getHandles();
        ArrayList<RepositoryHandle> accessibleHandles = new ArrayList<RepositoryHandle>();
        for (RepositoryHandle handle : handles) {
            if (!um.hasPermissionToAccess(user, handle)) continue;
            accessibleHandles.add(handle);
        }
        return accessibleHandles;
    }

    public static Map mapRepositories(HttpServletRequest request) {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(request);
        List<RepositoryHandle> handles = AppConfig.getsConfig().getRepositoryManager().getHandles();
        HashMap<String, RepositoryHandle> accessibleHandles = new HashMap<String, RepositoryHandle>();
        for (RepositoryHandle handle : handles) {
            if (!um.hasPermissionToAccess(user, handle)) continue;
            accessibleHandles.put(handle.getName(), handle);
        }
        return accessibleHandles;
    }

    public static boolean repositoriesAvailable() {
        return !AppConfig.getsConfig().getRepositoryManager().getHandles().isEmpty();
    }
}

