/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.license.fisheye;

import cenqua_com_licensing.atlassian.license.License;
import cenqua_com_licensing.atlassian.license.LicenseTypeStore;
import cenqua_com_licensing.atlassian.license.applications.fisheye.FishEyeLicenseTypeStore;
import com.cenqua.license.BaseAtlassianConverter;
import com.cenqua.license.CenquaLicense;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class FishEyeConverter
extends BaseAtlassianConverter {
    private static final Set DISPLAY_FOOTER_LICENSE_TYPES = new HashSet();
    private static final String PRODUCT = "FishEye";

    public CenquaLicense getCenquaLicense(String atlassianLicenseString) throws IOException {
        License l = this.getAtlassianLicense(atlassianLicenseString);
        Properties props = new Properties();
        props.put("fisheye.authtypes", "all");
        props.put("fisheye.jspsource", "true");
        props.put("fisheye.reptypes", "all");
        if (DISPLAY_FOOTER_LICENSE_TYPES.contains(l.getLicenseType())) {
            props.put("owner.verbose1", "true");
        }
        if (l.getLicenseType().requiresUserLimit()) {
            props.put("fisheye.maxusers", "" + l.getUsers());
        }
        return new CenquaLicense(PRODUCT, l, props);
    }

    public String getProductName() {
        return PRODUCT.toUpperCase();
    }

    public LicenseTypeStore createLicenseTypeStore() {
        return new FishEyeLicenseTypeStore();
    }

    static {
        DISPLAY_FOOTER_LICENSE_TYPES.add(FishEyeLicenseTypeStore.FISHEYE_EVALUATION);
        DISPLAY_FOOTER_LICENSE_TYPES.add(FishEyeLicenseTypeStore.FISHEYE_COMMUNITY);
        DISPLAY_FOOTER_LICENSE_TYPES.add(FishEyeLicenseTypeStore.FISHEYE_OPEN_SOURCE);
    }
}

