/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.repositories;

import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginJar;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class FilePluginInstaller
implements PluginInstaller {
    private File directory;

    public FilePluginInstaller(File directory) {
        this.directory = directory;
    }

    public void installPlugin(String key, PluginJar pluginJar) {
        File newPluginFile = new File(this.directory, pluginJar.getFileName());
        if (newPluginFile.exists()) {
            newPluginFile.delete();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(newPluginFile);
            FileUtils.copy(pluginJar.getInputStream(), os);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Could not install plugin: " + pluginJar, e);
            }
            catch (Throwable throwable) {
                FileUtils.shutdownStream(os);
                throw throwable;
            }
        }
        FileUtils.shutdownStream(os);
    }
}

