/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.xml.AbstractXMLHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLAnnotateHandler;
import org.tmatesoft.svn.core.wc.xml.SVNXMLSerializer;
import org.xml.sax.ContentHandler;

public class SVNAnnotateCommand
extends SVNCommand
implements ISVNAnnotateHandler {
    private boolean myIsVerbose;
    private PrintStream myPrintStream;

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        SVNRevision endRev;
        SVNRevision pegRevision;
        int i;
        SVNLogClient logClient = this.getClientManager().getLogClient();
        if (this.getCommandLine().hasArgument(SVNArgument.EXTENSIONS)) {
            SVNDiffOptions diffOptions = new SVNDiffOptions(this.getCommandLine().hasArgument(SVNArgument.IGNORE_ALL_WS), this.getCommandLine().hasArgument(SVNArgument.IGNORE_WS_CHANGE), this.getCommandLine().hasArgument(SVNArgument.IGNORE_EOL_STYLE));
            logClient.setDiffOptions(diffOptions);
        }
        this.myIsVerbose = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        this.myPrintStream = out;
        SVNRevision[] revRange = this.getStartEndRevisions();
        SVNRevision startRevision = revRange[0];
        SVNRevision endRevision = revRange[1];
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        SVNAnnotateCommand handler = this;
        SVNXMLSerializer serializer = null;
        if (this.getCommandLine().hasArgument(SVNArgument.XML)) {
            serializer = new SVNXMLSerializer((OutputStream)System.out);
            handler = new SVNXMLAnnotateHandler((ContentHandler)serializer);
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                ((AbstractXMLHandler)handler).startDocument();
            }
        }
        for (i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            String url = this.getCommandLine().getURL(i);
            pegRevision = this.getCommandLine().getPegRevision(i);
            if (serializer != null) {
                ((SVNXMLAnnotateHandler)handler).startTarget(url);
            }
            endRev = endRevision;
            if (!(endRevision != null && endRevision.isValid() || pegRevision != null && pegRevision.isValid())) {
                endRev = SVNRevision.HEAD;
            }
            try {
                logClient.doAnnotate(SVNURL.parseURIEncoded((String)url), pegRevision, startRevision, endRev, force, (ISVNAnnotateHandler)handler, null);
            }
            catch (SVNException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("binary") >= 0) {
                    out.println("Skipping binary file: '" + url + "'");
                }
                throw e;
            }
            if (serializer == null) continue;
            ((SVNXMLAnnotateHandler)handler).endTarget();
        }
        endRevision = SVNAnnotateCommand.parseRevision(this.getCommandLine());
        for (i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            File path = new File(this.getCommandLine().getPathAt(i)).getAbsoluteFile();
            pegRevision = this.getCommandLine().getPathPegRevision(i);
            if (serializer != null) {
                ((SVNXMLAnnotateHandler)handler).startTarget(this.getCommandLine().getPathAt(i));
            }
            endRev = endRevision;
            if (!(endRevision != null && endRevision.isValid() || pegRevision != null && pegRevision.isValid())) {
                endRev = SVNRevision.BASE;
            }
            try {
                logClient.doAnnotate(path, pegRevision, startRevision, endRev, force, (ISVNAnnotateHandler)handler);
            }
            catch (SVNException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("binary") >= 0) {
                    err.println("Skipping binary file: '" + SVNFormatUtil.formatPath((File)path) + "'");
                }
                throw e;
            }
            if (serializer == null) continue;
            ((SVNXMLAnnotateHandler)handler).endTarget();
        }
        if (this.getCommandLine().hasArgument(SVNArgument.XML)) {
            if (!this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL)) {
                ((AbstractXMLHandler)handler).endDocument();
            }
            try {
                serializer.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void handleLine(Date date, long revision, String author, String line) {
        StringBuffer result = new StringBuffer();
        if (this.myIsVerbose) {
            if (revision >= 0L) {
                result.append(SVNFormatUtil.formatString((String)Long.toString(revision), (int)6, (boolean)false));
                result.append(' ');
            } else {
                result.append("     -");
            }
            result.append(' ');
            result.append(author != null ? SVNFormatUtil.formatString((String)author, (int)10, (boolean)false) : "         -");
            result.append(' ');
            if (date != null) {
                result.append(SVNFormatUtil.formatHumanDate((Date)date, (ISVNOptions)this.getClientManager().getOptions()));
            } else {
                result.append("                                           -");
            }
            result.append(' ');
        } else {
            result.append(SVNFormatUtil.formatString((String)Long.toString(revision), (int)6, (boolean)false));
            result.append(' ');
            result.append(author != null ? SVNFormatUtil.formatString((String)author, (int)10, (boolean)false) : "         -");
            result.append(' ');
        }
        result.append(line);
        this.myPrintStream.println(result.toString());
    }
}

