/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNHistoryHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookHistoryCommand
extends SVNCommand
implements ISVNHistoryHandler {
    private PrintStream myOut;
    private boolean myIsIncludeIDs;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            SVNCommand.println(err, "Subcommand 'history' doesn't accept option '-t [--transaction] arg'");
            System.exit(1);
        }
        this.myOut = out;
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        String path = null;
        if (this.getCommandLine().getPathCount() > 1) {
            path = SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(1));
        }
        this.myIsIncludeIDs = this.getCommandLine().hasArgument(SVNArgument.SHOW_IDS);
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        if (this.myIsIncludeIDs) {
            SVNCommand.println(this.myOut, "REVISION   PATH <ID>");
            SVNCommand.println(this.myOut, "--------   ---------");
        } else {
            SVNCommand.println(this.myOut, "REVISION   PATH");
            SVNCommand.println(this.myOut, "--------   ----");
        }
        lookClient.doGetHistory(reposRoot, path, revision, this.myIsIncludeIDs, (ISVNHistoryHandler)this);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void handlePath(SVNAdminPath path) throws SVNException {
        if (path != null) {
            if (this.myIsIncludeIDs) {
                SVNCommand.println(this.myOut, path.getRevision() + "   " + path.getPath() + " <" + path.getNodeID() + ">");
            } else {
                SVNCommand.println(this.myOut, path.getRevision() + "   " + path.getPath());
            }
        }
    }
}

