/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNMoveCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasPaths() && this.getCommandLine().hasURLs()) {
            err.println("only URL->URL or WC->WC copy is supported");
            return;
        }
        if (this.getCommandLine().hasURLs()) {
            this.runRemote(out, err);
        } else {
            this.runLocally(out, err);
        }
    }

    private void runRemote(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().getURLCount() != 2) {
            SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Please enter SRC and DST URLs");
            throw new SVNException(msg);
        }
        String srcURL = this.getCommandLine().getURL(0);
        SVNRevision srcRevision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        String dstURL = this.getCommandLine().getURL(1);
        if (SVNMoveCommand.matchTabsInURL(srcURL, err) || SVNMoveCommand.matchTabsInURL(dstURL, err)) {
            return;
        }
        String commitMessage = (String)this.getCommandLine().getArgumentValue(SVNArgument.MESSAGE);
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCopyClient updater = this.getClientManager().getCopyClient();
        SVNCommitInfo result = updater.doCopy(SVNURL.parseURIEncoded((String)srcURL), srcRevision, SVNURL.parseURIDecoded((String)dstURL), true, commitMessage);
        if (result != SVNCommitInfo.NULL) {
            out.println();
            out.println("Committed revision " + result.getNewRevision() + ".");
        }
    }

    private void runLocally(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().getPathCount() != 2) {
            SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Please enter SRC and DST path");
            throw new SVNException(msg);
        }
        String absoluteSrcPath = this.getCommandLine().getPathAt(0);
        String absoluteDstPath = this.getCommandLine().getPathAt(1);
        if (SVNMoveCommand.matchTabsInPath(absoluteDstPath, err) || SVNMoveCommand.matchTabsInPath(absoluteSrcPath, err)) {
            return;
        }
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCopyClient updater = this.getClientManager().getCopyClient();
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        updater.doCopy(new File(absoluteSrcPath), SVNRevision.WORKING, new File(absoluteDstPath), force, true);
    }
}

