/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;

public class SVNSyncSynchronizeCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (this.getCommandLine().hasURLs()) {
            String destURL = this.getCommandLine().getURL(0);
            if (SVNSyncSynchronizeCommand.matchTabsInURL(destURL, err)) {
                return;
            }
            SVNClientManager manager = this.getClientManager();
            SVNAdminClient adminClient = manager.getAdminClient();
            final PrintStream outStream = out;
            adminClient.setReplayHandler(new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    SVNCommand.println(outStream, "Committed revision " + logEntry.getRevision() + ".");
                }
            });
            adminClient.doSynchronize(SVNURL.parseURIDecoded((String)destURL));
        }
    }
}

