/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.core;

import com.sun.ws.rest.api.core.ResourceConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceConfig
implements ResourceConfig {
    private final Set<Class> resources = new HashSet<Class>();
    private final Set<Class> providers = new HashSet<Class>();
    private final Map<String, Boolean> features = new HashMap<String, Boolean>();
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultResourceConfig() {
        this((Set<Class>)null);
    }

    public DefaultResourceConfig(Class ... resources) {
        this(new HashSet<Class>(Arrays.asList(resources)));
    }

    public DefaultResourceConfig(Set<Class> resources) {
        this.features.put("com.sun.ws.rest.config.feature.CanonicalizeURIPath", false);
        this.features.put("com.sun.ws.rest.config.feature.IgnoreMatrixParams", false);
        this.features.put("com.sun.ws.rest.config.feature.NormalizeURI", false);
        this.features.put("com.sun.ws.rest.config.feature.Redirect", false);
        if (null != resources) {
            this.resources.addAll(resources);
        }
    }

    @Override
    public Set<Class> getResourceClasses() {
        return this.resources;
    }

    @Override
    public Set<Class> getProviderClasses() {
        return this.providers;
    }

    @Override
    public Map<String, Boolean> getFeatures() {
        return this.features;
    }

    @Override
    public boolean getFeature(String featureName) {
        Boolean v = this.features.get(featureName);
        return v != null ? v : false;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }
}

