/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.uri;

import com.sun.ws.rest.api.uri.UriComponent;
import com.sun.ws.rest.api.uri.UriPattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriTemplate {
    public static final Comparator<UriTemplate> COMPARATOR = new Comparator<UriTemplate>(){

        @Override
        public int compare(UriTemplate o1, UriTemplate o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == EMPTY && o2 == EMPTY) {
                return 0;
            }
            if (o1 == EMPTY) {
                return 1;
            }
            if (o2 == EMPTY) {
                return -1;
            }
            int i = o2.getNumberOfExplicitCharacters() - o1.getNumberOfExplicitCharacters();
            if (i != 0) {
                return i;
            }
            i = o2.getNumberOfTemplateVariables() - o1.getNumberOfTemplateVariables();
            if (i != 0) {
                return i;
            }
            return o2.pattern.getRegex().compareTo(o1.pattern.getRegex());
        }
    };
    private static final Pattern TEMPLATE_NAMES_PATTERN = Pattern.compile("\\{([\\w-\\._~]+?)\\}");
    private static final String TEMPLATE_VALUE_REGEX = "(.*?)";
    public static final UriTemplate EMPTY = new UriTemplate();
    private final String template;
    private final UriPattern pattern;
    private final boolean endsWithSlash;
    private final List<String> templateVariables;
    private final int numOfCharacters;
    private static Set<Character> RESERVED_REGEX_CHARACTERS = UriTemplate.createReserved();

    private UriTemplate() {
        this.template = "";
        this.pattern = UriPattern.EMPTY;
        this.endsWithSlash = false;
        this.templateVariables = Collections.emptyList();
        this.numOfCharacters = 0;
    }

    public UriTemplate(String template) {
        if (template == null || template.length() == 0) {
            throw new IllegalArgumentException();
        }
        StringBuilder b = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int i = 0;
        int c = 0;
        while (m.find()) {
            c += m.start() - i;
            UriTemplate.copyURITemplateCharacters(template, i, m.start(), b);
            b.append(TEMPLATE_VALUE_REGEX);
            names.add(m.group(1));
            i = m.end();
        }
        UriTemplate.copyURITemplateCharacters(template, i, template.length(), b);
        this.template = template;
        this.pattern = new UriPattern(b.toString());
        this.numOfCharacters = c += template.length() - i;
        this.endsWithSlash = template.charAt(template.length() - 1) == '/';
        this.templateVariables = Collections.unmodifiableList(names);
    }

    private static void copyURITemplateCharacters(String template, int start, int end, StringBuilder b) {
        for (int i = start; i < end; ++i) {
            char c = template.charAt(i);
            if (RESERVED_REGEX_CHARACTERS.contains(Character.valueOf(c))) {
                b.append("\\");
            }
            b.append(c);
        }
    }

    private static Set<Character> createReserved() {
        char[] reserved = new char[]{'.', '?', '(', ')'};
        HashSet<Character> s = new HashSet<Character>();
        for (char c : reserved) {
            s.add(Character.valueOf(c));
        }
        return s;
    }

    public final String getTemplate() {
        return this.template;
    }

    public final UriPattern getPattern() {
        return this.pattern;
    }

    public final boolean endsWithSlash() {
        return this.endsWithSlash;
    }

    public final List<String> getTemplateVariables() {
        return this.templateVariables;
    }

    public final boolean isTemplateVariablePresent(String name) {
        for (String s : this.templateVariables) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public final int getNumberOfExplicitCharacters() {
        return this.numOfCharacters;
    }

    public final int getNumberOfTemplateVariables() {
        return this.templateVariables.size();
    }

    public final boolean match(CharSequence uri, Map<String, String> templateVariableToValue) {
        if (templateVariableToValue == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, this.templateVariables, templateVariableToValue);
    }

    public final boolean match(CharSequence uri, List<String> groupValues) {
        if (groupValues == null) {
            throw new IllegalArgumentException();
        }
        return this.pattern.match(uri, groupValues);
    }

    public final String createURI(Map<String, String> values) {
        StringBuilder b = new StringBuilder();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        int i = 0;
        while (m.find()) {
            b.append(this.template, i, m.start());
            String tValue = values.get(m.group(1));
            if (tValue != null) {
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(this.template, i, this.template.length());
        return b.toString();
    }

    public final String createURI(String ... values) {
        return this.createURI(values, 0, values.length);
    }

    public final String createURI(String[] values, int offset, int length) {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        StringBuilder b = new StringBuilder();
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(this.template);
        int v = offset;
        length += offset;
        int i = 0;
        while (m.find()) {
            b.append(this.template, i, m.start());
            String tVariable = m.group(1);
            String tValue = (String)mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else if (v < length && (tValue = values[v++]) != null) {
                mapValues.put(tVariable, tValue);
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(this.template, i, this.template.length());
        return b.toString();
    }

    public final String toString() {
        return this.pattern.toString();
    }

    public final int hashCode() {
        return this.pattern.hashCode();
    }

    public final boolean equals(Object o) {
        if (o instanceof UriTemplate) {
            UriTemplate that = (UriTemplate)o;
            return this.pattern.equals(that.pattern);
        }
        return false;
    }

    public static final String createURI(String scheme, String userInfo, String host, String port, String path, String query, String fragment, Map<String, String> values, boolean encode) {
        StringBuilder sb = new StringBuilder();
        if (scheme != null) {
            UriTemplate.createURIComponent(UriComponent.Type.SCHEME, scheme, values, false, sb).append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                UriTemplate.createURIComponent(UriComponent.Type.USER_INFO, userInfo, values, encode, sb).append('@');
            }
            if (host != null) {
                UriTemplate.createURIComponent(UriComponent.Type.HOST, host, values, encode, sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                UriTemplate.createURIComponent(UriComponent.Type.PORT, port, values, false, sb);
            }
        }
        if (path != null) {
            UriTemplate.createURIComponent(UriComponent.Type.PATH, path, values, encode, sb);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            UriTemplate.createURIComponent(UriComponent.Type.QUERY, query, values, encode, sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            UriTemplate.createURIComponent(UriComponent.Type.FRAGMENT, path, values, encode, sb);
        }
        return sb.toString();
    }

    private static StringBuilder createURIComponent(UriComponent.Type t, String template, Map<String, String> values, boolean encode, StringBuilder b) {
        if (template.indexOf(123) == -1) {
            b.append(template);
            return b;
        }
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int i = 0;
        while (m.find()) {
            b.append(template, i, m.start());
            String tValue = values.get(m.group(1));
            if (tValue != null) {
                if (encode) {
                    tValue = UriComponent.encode(tValue, t);
                } else {
                    UriComponent.validate(tValue, t);
                }
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(template, i, template.length());
        return b;
    }

    public static final String createURI(String scheme, String userInfo, String host, String port, String path, String query, String fragment, String[] values, boolean encode) {
        HashMap<String, String> mapValues = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        if (scheme != null) {
            offset = UriTemplate.createURIComponent(UriComponent.Type.SCHEME, scheme, values, offset, false, mapValues, sb);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != null) {
            sb.append("//");
            if (userInfo != null && userInfo.length() > 0) {
                offset = UriTemplate.createURIComponent(UriComponent.Type.USER_INFO, userInfo, values, offset, encode, mapValues, sb);
                sb.append('@');
            }
            if (host != null) {
                offset = UriTemplate.createURIComponent(UriComponent.Type.HOST, host, values, offset, encode, mapValues, sb);
            }
            if (port != null && port.length() > 0) {
                sb.append(':');
                offset = UriTemplate.createURIComponent(UriComponent.Type.PORT, port, values, offset, false, mapValues, sb);
            }
        }
        if (path != null) {
            offset = UriTemplate.createURIComponent(UriComponent.Type.PATH, path, values, offset, encode, mapValues, sb);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            offset = UriTemplate.createURIComponent(UriComponent.Type.QUERY, query, values, offset, encode, mapValues, sb);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            offset = UriTemplate.createURIComponent(UriComponent.Type.FRAGMENT, path, values, offset, encode, mapValues, sb);
        }
        return sb.toString();
    }

    private static int createURIComponent(UriComponent.Type t, String template, String[] values, int offset, boolean encode, Map<String, String> mapValues, StringBuilder b) {
        Matcher m = TEMPLATE_NAMES_PATTERN.matcher(template);
        int v = offset;
        int i = 0;
        while (m.find()) {
            b.append(template, i, m.start());
            String tVariable = m.group(1);
            String tValue = mapValues.get(tVariable);
            if (tValue != null) {
                b.append(tValue);
            } else if (v < values.length && (tValue = values[v++]) != null) {
                mapValues.put(tVariable, tValue);
                if (encode) {
                    tValue = UriComponent.encode(tValue, t);
                } else {
                    UriComponent.validate(tValue, t);
                }
                b.append(tValue);
            }
            i = m.end();
        }
        b.append(template, i, template.length());
        return v;
    }
}

