/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl;

import com.sun.ws.rest.impl.util.KeyComparatorHashMap;
import com.sun.ws.rest.impl.util.StringIgnoreCaseKeyComparator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestHttpHeadersImpl
extends KeyComparatorHashMap<String, List<String>>
implements MultivaluedMap<String, String> {
    public RequestHttpHeadersImpl() {
        super(StringIgnoreCaseKeyComparator.SINGLETON);
    }

    public void putSingle(String key, String value) {
        if (value == null) {
            return;
        }
        List<String> l = this.getList(key);
        l.clear();
        l.add(value);
    }

    public void add(String key, String value) {
        if (value == null) {
            return;
        }
        List<String> l = this.getList(key);
        l.add(value);
    }

    public String getFirst(String key) {
        List values = (List)this.get(key);
        if (values != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public <A> List<A> get(String key, Class<A> type) {
        Constructor<A> c = null;
        try {
            c = type.getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(type.getName() + " has no String constructor", ex);
        }
        ArrayList<A> l = null;
        List values = (List)this.get(key);
        if (values != null) {
            l = new ArrayList<A>();
            for (String value : values) {
                try {
                    l.add(c.newInstance(value));
                }
                catch (Exception ex) {
                    l.add(null);
                }
            }
        }
        return l;
    }

    public void putSingle(String key, Object value) {
        List<String> l = this.getList(key);
        l.clear();
        if (value != null) {
            l.add(value.toString());
        } else {
            l.add("");
        }
    }

    public void add(String key, Object value) {
        List<String> l = this.getList(key);
        if (value != null) {
            l.add(value.toString());
        } else {
            l.add("");
        }
    }

    private List<String> getList(String key) {
        LinkedList l = (LinkedList)this.get(key);
        if (l == null) {
            l = new LinkedList();
            this.put(key, l);
        }
        return l;
    }

    public <A> A getFirst(String key, Class<A> type) {
        String value = this.getFirst(key);
        if (value == null) {
            return null;
        }
        Constructor<A> c = null;
        try {
            c = type.getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(type.getName() + " has no String constructor", ex);
        }
        A retVal = null;
        try {
            retVal = c.newInstance(value);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }

    public <A> A getFirst(String key, A defaultValue) {
        String value = this.getFirst(key);
        if (value == null) {
            return defaultValue;
        }
        Class<?> type = defaultValue.getClass();
        Constructor<?> c = null;
        try {
            c = type.getConstructor(String.class);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(type.getName() + " has no String constructor", ex);
        }
        Object retVal = defaultValue;
        try {
            retVal = c.newInstance(value);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return retVal;
    }
}

