/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.model;

import com.sun.ws.rest.api.MediaTypes;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.api.model.AbstractResource;
import com.sun.ws.rest.api.model.AbstractResourceMethod;
import com.sun.ws.rest.api.model.AbstractSubResourceLocator;
import com.sun.ws.rest.api.model.AbstractSubResourceMethod;
import com.sun.ws.rest.api.view.Views;
import com.sun.ws.rest.impl.model.ResourceMethodMap;
import com.sun.ws.rest.impl.model.RulesMap;
import com.sun.ws.rest.impl.model.method.ResourceHeadWrapperMethod;
import com.sun.ws.rest.impl.model.method.ResourceHttpMethod;
import com.sun.ws.rest.impl.model.method.ResourceHttpOptionsMethod;
import com.sun.ws.rest.impl.model.method.ResourceMethod;
import com.sun.ws.rest.impl.model.method.ResourceViewMethod;
import com.sun.ws.rest.impl.model.parameter.ParameterExtractorFactory;
import com.sun.ws.rest.impl.uri.PathPattern;
import com.sun.ws.rest.impl.uri.PathTemplate;
import com.sun.ws.rest.impl.uri.rules.HttpMethodRule;
import com.sun.ws.rest.impl.uri.rules.RightHandPathRule;
import com.sun.ws.rest.impl.uri.rules.SubLocatorRule;
import com.sun.ws.rest.impl.uri.rules.UriRulesFactory;
import com.sun.ws.rest.impl.view.ViewFactory;
import com.sun.ws.rest.impl.wadl.WadlFactory;
import com.sun.ws.rest.spi.resource.ResourceProvider;
import com.sun.ws.rest.spi.resource.ResourceProviderFactory;
import com.sun.ws.rest.spi.service.ComponentProvider;
import com.sun.ws.rest.spi.uri.rules.UriRule;
import com.sun.ws.rest.spi.uri.rules.UriRules;
import com.sun.ws.rest.spi.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceClass {
    private static final Logger LOGGER = Logger.getLogger(ResourceClass.class.getName());
    private final UriRules<UriRule> rules;
    private final ResourceConfig config;
    public final AbstractResource resource;
    public final ResourceProvider resolver;
    public final boolean hasSubResources;

    public ResourceClass(ResourceConfig config, ComponentProvider provider, ResourceProviderFactory resolverFactory, AbstractResource resource) {
        this.resource = resource;
        this.config = config;
        this.resolver = resolverFactory.createProvider(provider, resource, config.getFeatures(), config.getProperties());
        boolean hasSubResourcesAux = false;
        RulesMap<UriRule> rulesMap = new RulesMap<UriRule>();
        hasSubResourcesAux = this.processSubResourceLocators(rulesMap);
        Map<PathPattern, ResourceMethodMap> patternMethodMap = this.processSubResourceMethods();
        ResourceMethodMap methodMap = this.processMethods();
        this.processViews(provider, methodMap, patternMethodMap);
        for (Map.Entry<PathPattern, ResourceMethodMap> e : patternMethodMap.entrySet()) {
            hasSubResourcesAux = true;
            PathPattern p = e.getKey();
            ResourceMethodMap rmm = e.getValue();
            rmm.sort();
            this.processWadl(resource, p, rmm);
            rulesMap.put(p, new RightHandPathRule(config.getFeature("com.sun.ws.rest.config.feature.Redirect"), p.getTemplate().endsWithSlash(), new HttpMethodRule(rmm)));
        }
        methodMap.sort();
        if (!rulesMap.isEmpty() || methodMap.size() > 1) {
            this.processWadl(resource, methodMap);
        }
        if (!methodMap.isEmpty()) {
            rulesMap.put(PathPattern.EMPTY_PATH, new HttpMethodRule(methodMap));
        }
        this.hasSubResources = hasSubResourcesAux;
        this.rules = UriRulesFactory.create(rulesMap);
    }

    public UriRules<UriRule> getRules() {
        return this.rules;
    }

    private void addToPatternMethodMap(Map<PathPattern, ResourceMethodMap> tmm, PathPattern p, ResourceMethod rm) {
        ResourceMethodMap rmm = tmm.get(p);
        if (rmm == null) {
            rmm = new ResourceMethodMap();
            tmm.put(p, rmm);
        }
        rmm.put(rm);
    }

    private boolean processSubResourceLocators(RulesMap<UriRule> rulesMap) {
        boolean hasSubResources = false;
        for (AbstractSubResourceLocator locator : this.resource.getSubResourceLocators()) {
            hasSubResources = true;
            PathTemplate t = new PathTemplate(locator.getUriPath().getValue(), locator.getUriPath().isEncode());
            PathPattern p = new PathPattern(t, locator.getUriPath().isLimited());
            SubLocatorRule r = new SubLocatorRule(t.getTemplateVariables(), locator.getMethod(), ParameterExtractorFactory.createExtractorsForSublocator(locator));
            rulesMap.put(p, new RightHandPathRule(this.config.getFeature("com.sun.ws.rest.config.feature.Redirect"), t.endsWithSlash(), r));
        }
        return hasSubResources;
    }

    private Map<PathPattern, ResourceMethodMap> processSubResourceMethods() {
        HashMap<PathPattern, ResourceMethodMap> patternMethodMap = new HashMap<PathPattern, ResourceMethodMap>();
        for (AbstractSubResourceMethod abstractSubResourceMethod : this.resource.getSubResourceMethods()) {
            PathTemplate t = new PathTemplate(abstractSubResourceMethod.getUriPath().getValue(), abstractSubResourceMethod.getUriPath().isEncode());
            PathPattern p = new PathPattern(t, false);
            ResourceHttpMethod rm = new ResourceHttpMethod(t.getTemplateVariables(), abstractSubResourceMethod);
            this.addToPatternMethodMap(patternMethodMap, p, rm);
        }
        for (Map.Entry entry : patternMethodMap.entrySet()) {
            this.processHead((ResourceMethodMap)entry.getValue());
            this.processOptions((ResourceMethodMap)entry.getValue(), this.resource, (PathPattern)entry.getKey());
        }
        return patternMethodMap;
    }

    private ResourceMethodMap processMethods() {
        ResourceMethodMap methodMap = new ResourceMethodMap();
        for (AbstractResourceMethod resourceMethod : this.resource.getResourceMethods()) {
            ResourceHttpMethod rm = new ResourceHttpMethod(resourceMethod);
            methodMap.put(rm);
        }
        this.processHead(methodMap);
        this.processOptions(methodMap, this.resource, null);
        return methodMap;
    }

    private void processHead(ResourceMethodMap methodMap) {
        List getList = (List)methodMap.get("GET");
        if (getList == null || getList.isEmpty()) {
            return;
        }
        List<ResourceMethod> headList = (ArrayList<ResourceMethod>)methodMap.get("HEAD");
        if (headList == null) {
            headList = new ArrayList<ResourceMethod>();
        }
        for (ResourceMethod getMethod : getList) {
            if (this.containsMediaOfMethod(headList, getMethod)) continue;
            ResourceHeadWrapperMethod headMethod = new ResourceHeadWrapperMethod(getMethod);
            methodMap.put(headMethod);
            headList = (List)methodMap.get("HEAD");
        }
    }

    private boolean containsMediaOfMethod(List<ResourceMethod> methods, ResourceMethod method) {
        for (ResourceMethod m : methods) {
            if (!method.mediaEquals(m)) continue;
            return true;
        }
        return false;
    }

    private void processOptions(ResourceMethodMap methodMap, AbstractResource resource, PathPattern p) {
        List l = (List)methodMap.get("OPTIONS");
        if (l != null) {
            return;
        }
        ResourceMethod optionsMethod = WadlFactory.createWadlOptionsMethod(methodMap, resource, p);
        if (optionsMethod == null) {
            optionsMethod = new ResourceHttpOptionsMethod(methodMap);
        }
        methodMap.put(optionsMethod);
    }

    private void processViews(ComponentProvider provider, ResourceMethodMap methodMap, Map<PathPattern, ResourceMethodMap> patternMethodMap) {
        Map<String, Class<?>> viewMap = this.getViews();
        for (Map.Entry<String, Class<?>> view : viewMap.entrySet()) {
            Class<?> resourceClass = view.getValue();
            String viewName = view.getKey();
            String path = this.getAbsolutePathOfView(resourceClass, viewName);
            String pathPattern = this.getPathPatternOfView(resourceClass, viewName);
            View v = ViewFactory.createView(provider, path);
            if (v == null) continue;
            ResourceViewMethod rm = new ResourceViewMethod(v);
            if (pathPattern.length() == 0) {
                methodMap.put(rm);
                continue;
            }
            PathTemplate t = new PathTemplate(pathPattern, true);
            PathPattern p = new PathPattern(t, false);
            this.addToPatternMethodMap(patternMethodMap, p, rm);
        }
    }

    private Map<String, Class<?>> getViews() {
        HashMap viewMap = new HashMap();
        HashSet<String> views = new HashSet<String>();
        for (Class<?> resourceClass = this.resource.getResourceClass(); resourceClass != null; resourceClass = resourceClass.getSuperclass()) {
            Views vAnnotation = resourceClass.getAnnotation(Views.class);
            if (vAnnotation == null) continue;
            for (String name : vAnnotation.value()) {
                if (views.contains(name) || !name.startsWith("/") && name.contains("/")) continue;
                views.add(name);
                viewMap.put(name, resourceClass);
            }
        }
        return viewMap;
    }

    private String getPathPatternOfView(Class<?> resourceClass, String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        if (path.matches("index\\.[^/]*")) {
            return "";
        }
        int i = path.lastIndexOf(46);
        if (i > 0) {
            path = path.substring(0, i);
        }
        return path;
    }

    private String getAbsolutePathOfView(Class<?> resourceClass, String path) {
        if (path.startsWith("/")) {
            return null;
        }
        return this.getAbsolutePathOfClass(resourceClass) + '/' + path;
    }

    private String getAbsolutePathOfClass(Class<?> resourceClass) {
        return "/" + resourceClass.getName().replace('.', '/').replace('$', '/');
    }

    private void processWadl(AbstractResource resource, ResourceMethodMap methodMap) {
        this.processWadl(resource, null, methodMap);
    }

    private void processWadl(AbstractResource resource, PathPattern p, ResourceMethodMap methodMap) {
        ResourceMethod wadlMethod;
        if (methodMap.get("GET") != null) {
            for (ResourceMethod getMethod : (List)methodMap.get("GET")) {
                for (MediaType m : getMethod.getProduceMime()) {
                    if (!m.equals((Object)MediaTypes.WADL)) continue;
                    return;
                }
            }
        }
        if ((wadlMethod = WadlFactory.createWadlGetMethod(resource, p)) != null) {
            methodMap.put(wadlMethod);
        }
    }
}

