/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.impl.provider.header;

import com.sun.ws.rest.impl.http.header.writer.WriterUtil;
import com.sun.ws.rest.spi.HeaderDelegateProvider;
import javax.ws.rs.core.NewCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCookieProvider
implements HeaderDelegateProvider<NewCookie> {
    @Override
    public boolean supports(Class<?> type) {
        return type == NewCookie.class;
    }

    public String toString(NewCookie cookie) {
        StringBuilder b = new StringBuilder();
        b.append(cookie.getName());
        b.append('=');
        WriterUtil.appendQuotedIfWhitespace(b, cookie.getValue());
        b.append(";Version=");
        b.append(cookie.getVersion());
        if (cookie.getComment() != null) {
            b.append(";Comment=");
            WriterUtil.appendQuotedIfWhitespace(b, cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            b.append(";Domain=");
            WriterUtil.appendQuotedIfWhitespace(b, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            b.append(";Path=");
            WriterUtil.appendQuotedIfWhitespace(b, cookie.getPath());
        }
        if (cookie.getMaxAge() != -1) {
            b.append(";Max-Age=");
            b.append(cookie.getMaxAge());
        }
        if (cookie.isSecure()) {
            b.append(";Secure");
        }
        return b.toString();
    }

    public NewCookie fromString(String header) {
        throw new UnsupportedOperationException();
    }
}

