/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.spi.container;

import com.sun.ws.rest.api.Responses;
import com.sun.ws.rest.api.uri.UriComponent;
import com.sun.ws.rest.impl.MultivaluedMapImpl;
import com.sun.ws.rest.impl.RequestHttpHeadersImpl;
import com.sun.ws.rest.impl.VariantSelector;
import com.sun.ws.rest.impl.http.header.AcceptableMediaType;
import com.sun.ws.rest.impl.http.header.reader.HttpHeaderReader;
import com.sun.ws.rest.impl.model.HttpHelper;
import com.sun.ws.rest.spi.container.ContainerRequest;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerRequest
implements ContainerRequest {
    private final MessageBodyContext bodyContext;
    private final String method;
    private final InputStream entity;
    protected URI baseUri;
    protected URI completeUri;
    private URI absoluteUri;
    private String encodedPath;
    private String decodedPath;
    private List<PathSegment> decodedPathSegments;
    private List<PathSegment> encodedPathSegments;
    private MultivaluedMap<String, String> decodedQueryParameters;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> encodedTemplateValues;
    private MultivaluedMap<String, String> decodedTemplateValues;
    private MultivaluedMap<String, String> headers;
    private MediaType contentType;
    private List<MediaType> accept;
    private Map<String, Cookie> cookies;

    protected AbstractContainerRequest(MessageBodyContext bodyContext, String method, InputStream entity) {
        this.bodyContext = bodyContext;
        this.method = method;
        this.headers = new RequestHttpHeadersImpl();
        this.encodedTemplateValues = new MultivaluedMapImpl();
        this.entity = entity;
    }

    @Override
    public void addTemplateValues(List<String> names, List<String> values) {
        int i = 0;
        for (String name : names) {
            String value = values.get(i++);
            this.encodedTemplateValues.putSingle((Object)name, (Object)value);
            if (this.decodedTemplateValues == null) continue;
            this.decodedTemplateValues.putSingle((Object)UriComponent.decode(name, UriComponent.Type.PATH_SEGMENT), (Object)UriComponent.decode(value, UriComponent.Type.PATH));
        }
    }

    @Override
    public String getHeaderValue(String name) {
        List v = (List)this.getRequestHeaders().get((Object)name);
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return "";
        }
        if (v.size() == 1) {
            return (String)v.get(0);
        }
        StringBuilder sb = new StringBuilder((String)v.get(0));
        for (int i = 1; i < v.size(); ++i) {
            String s = (String)v.get(i);
            if (s.length() <= 0) continue;
            sb.append(',').append(s);
        }
        return sb.toString();
    }

    @Override
    public <T> T getEntity(Class<T> type) {
        try {
            MediaType mediaType = this.getMediaType();
            return (T)this.bodyContext.getMessageBodyReader(type, mediaType).readFrom(type, mediaType, this.headers, this.entity);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getHttpMethod() {
        return this.method;
    }

    @Override
    public MediaType getAcceptableMediaType(List<MediaType> mediaTypes) {
        for (MediaType a : this.getAcceptableMediaTypes()) {
            if (a.getType().equals("*")) {
                return mediaTypes.get(0);
            }
            for (MediaType m : mediaTypes) {
                if (!m.isCompatible(a)) continue;
                return m;
            }
        }
        return null;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (decode) {
            if (this.decodedPath != null) {
                return this.decodedPath;
            }
            this.decodedPath = UriComponent.decode(this.getEncodedPath(), UriComponent.Type.PATH);
            return this.decodedPath;
        }
        return this.getEncodedPath();
    }

    private String getEncodedPath() {
        if (this.encodedPath != null) {
            return this.encodedPath;
        }
        this.encodedPath = this.completeUri.getRawPath().substring(this.baseUri.getRawPath().length());
        return this.encodedPath;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            if (this.decodedPathSegments != null) {
                return this.decodedPathSegments;
            }
            this.decodedPathSegments = this.extractPathSegments(this.getPath(false), true);
            return this.decodedPathSegments;
        }
        if (this.encodedPathSegments != null) {
            return this.encodedPathSegments;
        }
        this.encodedPathSegments = this.extractPathSegments(this.getPath(false), false);
        return this.encodedPathSegments;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    public URI getAbsolutePath() {
        if (this.absoluteUri != null) {
            return this.absoluteUri;
        }
        this.absoluteUri = this.getRequestUriBuilder().encode(false).replaceQueryParams("").fragment("").build();
        return this.absoluteUri;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public URI getRequestUri() {
        return this.completeUri;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    public MultivaluedMap<String, String> getTemplateParameters() {
        return this.getTemplateParameters(true);
    }

    public MultivaluedMap<String, String> getTemplateParameters(boolean decode) {
        if (decode) {
            if (this.decodedTemplateValues != null) {
                return this.decodedTemplateValues;
            }
            this.decodedTemplateValues = new MultivaluedMapImpl();
            for (Map.Entry e : this.encodedTemplateValues.entrySet()) {
                ArrayList<String> l = new ArrayList<String>();
                for (String v : (List)e.getValue()) {
                    l.add(UriComponent.decode(v, UriComponent.Type.PATH));
                }
                this.decodedTemplateValues.put((Object)UriComponent.decode((String)e.getKey(), UriComponent.Type.PATH_SEGMENT), l);
            }
            return this.decodedTemplateValues;
        }
        return this.encodedTemplateValues;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            if (this.decodedQueryParameters != null) {
                return this.decodedQueryParameters;
            }
            this.decodedQueryParameters = UriComponent.decodeQuery(this.getRequestUri(), true);
            return this.decodedQueryParameters;
        }
        if (this.encodedQueryParameters != null) {
            return this.encodedQueryParameters;
        }
        this.encodedQueryParameters = UriComponent.decodeQuery(this.getRequestUri(), false);
        return this.encodedQueryParameters;
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.headers;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        if (this.accept == null) {
            this.accept = new ArrayList<AcceptableMediaType>(HttpHelper.getAccept(this));
        }
        return this.accept;
    }

    public MediaType getMediaType() {
        if (this.contentType == null) {
            this.contentType = HttpHelper.getContentType(this);
        }
        return this.contentType;
    }

    public String getLanguage() {
        return (String)this.getRequestHeaders().getFirst((Object)"Langauge");
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new HashMap<String, Cookie>();
        }
        return this.cookies;
    }

    private List<PathSegment> extractPathSegments(String path, boolean decode) {
        String[] subPaths;
        LinkedList<PathSegment> pathSegments = new LinkedList<PathSegment>();
        if (path == null) {
            return pathSegments;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ((subPaths = path.split("/")).length == 0) {
            PathSegmentImpl pathSegment = new PathSegmentImpl("", new MultivaluedMapImpl());
            pathSegments.add(pathSegment);
            return pathSegments;
        }
        for (String subPath : subPaths) {
            if (subPath.length() == 0) continue;
            MultivaluedMapImpl matrixMap = new MultivaluedMapImpl();
            int colon = subPath.indexOf(59);
            if (colon != -1) {
                String matrixParameters = subPath.substring(colon + 1);
                subPath = colon == 0 ? "" : subPath.substring(0, colon);
                this.extractPathParameters(matrixParameters, ";", matrixMap, decode);
            }
            if (decode) {
                subPath = UriComponent.decode(subPath, UriComponent.Type.PATH_SEGMENT);
            }
            PathSegmentImpl pathSegment = new PathSegmentImpl(subPath, matrixMap);
            pathSegments.add(pathSegment);
        }
        return pathSegments;
    }

    private void extractPathParameters(String parameters, String deliminator, MultivaluedMap<String, String> map, boolean decode) {
        for (String s : parameters.split(deliminator)) {
            String key;
            if (s.length() == 0) continue;
            String[] keyVal = s.split("=");
            String string = key = decode ? UriComponent.decode(keyVal[0], UriComponent.Type.PATH_SEGMENT) : keyVal[0];
            if (key.length() == 0) continue;
            String val = keyVal.length == 2 ? (decode ? UriComponent.decode(keyVal[1], UriComponent.Type.PATH_SEGMENT) : keyVal[1]) : "";
            LinkedList<String> list = (LinkedList<String>)map.get((Object)key);
            if (map.get((Object)key) == null) {
                list = new LinkedList<String>();
                map.put((Object)key, list);
            }
            list.add(val);
        }
    }

    public Variant selectVariant(List<Variant> variants) {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException("The list of variants is null or empty");
        }
        return VariantSelector.selectVariant(this, variants);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r == null) {
            r = this.evaluateIfNoneMatch(eTag);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        long lastModifiedTime = lastModified.getTime();
        Response.ResponseBuilder r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r == null) {
            r = this.evaluateIfModifiedSince(lastModifiedTime);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r == null) {
            long lastModifiedTime = lastModified.getTime();
            r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
            if (r == null) {
                r = this.evaluateIfNoneMatch(eTag);
            }
            if (r == null) {
                r = this.evaluateIfModifiedSince(lastModifiedTime);
            }
        }
        return r;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        String ifMatchHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Match");
        if (ifMatchHeader != null && !ifMatchHeader.trim().equals("*") && !ifMatchHeader.contains(eTag.getValue())) {
            return Responses.preconditionFailed();
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag) {
        String ifNoneMatchHeader = (String)this.getRequestHeaders().getFirst((Object)"If-None-Match");
        if (ifNoneMatchHeader != null && (ifNoneMatchHeader.trim().equals("*") || ifNoneMatchHeader.contains(eTag.getValue()))) {
            String httpMethod = this.getHttpMethod();
            if (httpMethod.equals("GET") || httpMethod.equals("HEAD")) {
                return Response.notModified((EntityTag)eTag);
            }
            return Responses.preconditionFailed();
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(long lastModified) {
        String ifUnmodifiedSinceHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Unmodified-Since");
        if (ifUnmodifiedSinceHeader != null) {
            try {
                long ifUnmodifiedSince = HttpHeaderReader.readDate(ifUnmodifiedSinceHeader).getTime() + 1000L;
                if (lastModified > ifUnmodifiedSince) {
                    return Responses.preconditionFailed();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified) {
        String ifModifiedSinceHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Modified-Since");
        if (ifModifiedSinceHeader != null) {
            try {
                long ifModifiedSince = HttpHeaderReader.readDate(ifModifiedSinceHeader).getTime() + 1000L;
                if (ifModifiedSince > lastModified) {
                    return Responses.notModified();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticationScheme() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PathSegmentImpl
    implements PathSegment {
        private String path;
        private MultivaluedMap<String, String> matrixParameters;

        PathSegmentImpl(String path, MultivaluedMap<String, String> matrixParameters) {
            this.path = path;
            this.matrixParameters = matrixParameters;
        }

        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.matrixParameters;
        }
    }
}

