/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.spi.container;

import com.sun.ws.rest.api.Responses;
import com.sun.ws.rest.impl.ResponseHttpHeadersImpl;
import com.sun.ws.rest.impl.ResponseImpl;
import com.sun.ws.rest.spi.container.ContainerRequest;
import com.sun.ws.rest.spi.container.ContainerResponse;
import com.sun.ws.rest.spi.container.MessageBodyContext;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerResponse
implements ContainerResponse {
    private static final MediaType APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    private final MessageBodyContext bodyContext;
    private final ContainerRequest request;
    private int status;
    private MultivaluedMap<String, Object> headers;
    private Object entity;
    private boolean isCommitted;
    private OutputStream out;

    protected AbstractContainerResponse(MessageBodyContext bodyContext, ContainerRequest request) {
        this.bodyContext = bodyContext;
        this.request = request;
        this.status = 204;
    }

    protected abstract OutputStream getUnderlyingOutputStream() throws IOException;

    protected abstract void commitStatusAndHeaders() throws IOException;

    @Override
    public final void setResponse(Response response) {
        this.setResponse(response, APPLICATION_OCTET_STREAM);
    }

    @Override
    public final void setResponse(Response response, MediaType contentType) {
        if (contentType == null) {
            contentType = APPLICATION_OCTET_STREAM;
        }
        response = response != null ? response : Responses.noContent().build();
        this.status = response.getStatus();
        this.entity = response.getEntity();
        if (this.request.getHttpMethod().equals("HEAD")) {
            this.entity = null;
        } else if (this.entity == null) {
            contentType = null;
            if (this.status == 200) {
                this.status = 204;
            }
        } else if (this.status == 204) {
            this.status = 200;
        }
        this.headers = response instanceof ResponseImpl ? this.setResponseOptimal((ResponseImpl)response, contentType) : this.setResponseNonOptimal(response, contentType);
    }

    @Override
    public final int getStatus() {
        return this.status;
    }

    @Override
    public final void setStatus(int status) {
        this.status = status;
    }

    @Override
    public final Object getEntity() {
        return this.entity;
    }

    @Override
    public final void setEntity(Object entity) {
        this.entity = entity;
        this.checkStatusAndEntity();
    }

    @Override
    public final MultivaluedMap<String, Object> getHttpHeaders() {
        if (this.headers == null) {
            this.headers = new ResponseHttpHeadersImpl();
        }
        return this.headers;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new CommittingOutputStream(this.getUnderlyingOutputStream());
        }
        return this.out;
    }

    @Override
    public final boolean isCommitted() {
        return this.isCommitted;
    }

    protected final void writeEntity(OutputStream out) throws IOException {
        Object entity = this.getEntity();
        if (entity != null) {
            this.writeEntity(entity, out);
        }
    }

    protected final void writeEntity(Object entity, OutputStream out) throws IOException {
        MediaType mediaType = null;
        Object mediaTypeHeader = this.getHttpHeaders().getFirst((Object)"Content-Type");
        mediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader != null ? MediaType.parse((String)mediaTypeHeader.toString()) : APPLICATION_OCTET_STREAM);
        MessageBodyWriter<?> p = this.bodyContext.getMessageBodyWriter(entity.getClass(), mediaType);
        p.writeTo(entity, mediaType, this.getHttpHeaders(), out);
    }

    private void checkStatusAndEntity() {
        if (this.status == 204 && this.entity != null) {
            this.status = 200;
        } else if (this.status == 200 && this.entity == null) {
            this.status = 204;
        }
    }

    private MultivaluedMap<String, Object> setResponseOptimal(ResponseImpl r, MediaType contentType) {
        return r.getMetadataOptimal(this.request, contentType);
    }

    private MultivaluedMap<String, Object> setResponseNonOptimal(Response r, MediaType contentType) {
        Object location;
        MultivaluedMap headers = r.getMetadata();
        if (headers.getFirst((Object)"Content-Type") == null && contentType != null) {
            headers.putSingle((Object)"Content-Type", (Object)contentType);
        }
        if ((location = headers.getFirst((Object)"Location")) != null && location instanceof URI) {
            URI absoluteLocation = this.request.getBaseUri().resolve((URI)location);
            headers.putSingle((Object)"Location", (Object)absoluteLocation);
        }
        return headers;
    }

    public String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = RuntimeDelegate.getInstance().createHeaderDelegate(headerValue.getClass());
        return hp.toString(headerValue);
    }

    private final class CommittingOutputStream
    extends OutputStream {
        final OutputStream o;

        CommittingOutputStream(OutputStream o) {
            this.o = o;
        }

        public void write(byte[] b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.commitWrite();
            this.o.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.commitWrite();
            this.o.write(b);
        }

        public void flush() throws IOException {
            this.o.flush();
        }

        public void close() throws IOException {
            this.commitClose();
            this.o.close();
        }

        private void commitWrite() throws IOException {
            if (!AbstractContainerResponse.this.isCommitted) {
                if (AbstractContainerResponse.this.getStatus() == 204) {
                    AbstractContainerResponse.this.setStatus(200);
                }
                AbstractContainerResponse.this.isCommitted = true;
                AbstractContainerResponse.this.commitStatusAndHeaders();
            }
        }

        private void commitClose() throws IOException {
            if (!AbstractContainerResponse.this.isCommitted) {
                AbstractContainerResponse.this.isCommitted = true;
                AbstractContainerResponse.this.commitStatusAndHeaders();
            }
        }
    }
}

