/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.filter;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultEncryptedCertificate;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.TransportErrorMessage;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.seraph.auth.RoleMapper;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.filter.BaseLoginFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.Principal;
import java.security.PublicKey;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;

public class TrustedApplicationsFilter
implements Filter {
    private static final Logger log = Logger.getLogger((Class)TrustedApplicationsFilter.class);
    private final CertificateServer certificateServer;
    private final Authenticator authenticator;
    private FilterConfig filterConfig = null;

    public TrustedApplicationsFilter(TrustedApplicationsManager appManager, UserResolver resolver) {
        this(appManager, resolver, SecurityConfigFactory.getInstance().getRoleMapper());
    }

    public TrustedApplicationsFilter(TrustedApplicationsManager appManager, UserResolver resolver, RoleMapper roleMapper) {
        this(new CertificateServerImpl(appManager), new AuthenticatorImpl(appManager, resolver, roleMapper));
    }

    TrustedApplicationsFilter(CertificateServer certificateServer, Authenticator authenticator) {
        TrustedApplicationsFilter.notNull("certificateServer", certificateServer);
        TrustedApplicationsFilter.notNull("authenticator", authenticator);
        this.certificateServer = certificateServer;
        this.authenticator = authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String status;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.getPathInfo(request).endsWith("/admin/appTrustCertificate")) {
            response.setContentType("text/plain");
            this.certificateServer.writeCertificate(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            return;
        }
        boolean isTrustedAppCall = false;
        if (request.getAttribute("os_authstatus") == null && "success".equals(status = this.authenticate((HttpServletRequest)req, (HttpServletResponse)res))) {
            request.setAttribute("os_authstatus", (Object)status);
            response.setHeader("X-Seraph-Trusted-App-Status", "OK");
            isTrustedAppCall = true;
        }
        try {
            chain.doFilter((ServletRequest)request, res);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (isTrustedAppCall && request.getSession(false) != null) {
                request.getSession().invalidate();
            }
            throw throwable;
        }
        if (isTrustedAppCall && request.getSession(false) != null) {
            request.getSession().invalidate();
        }
    }

    public String authenticate(HttpServletRequest request, HttpServletResponse response) {
        Authenticator.Result result = this.authenticator.authenticate(request);
        switch (result.getStatus().getOrdinal()) {
            case 3: {
                return BaseLoginFilter.LOGIN_NOATTEMPT;
            }
            case 1: {
                this.setFailureHeader(response, result.getMessage());
                return "failed";
            }
            case 2: {
                this.setFailureHeader(response, result.getMessage());
                return "error";
            }
            case 0: {
                request.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)result.getUser());
                request.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
                return "success";
            }
        }
        throw new IllegalStateException("Unknown result: " + result.getStatus().getOrdinal());
    }

    protected String getPathInfo(HttpServletRequest request) {
        String context = request.getContextPath();
        String uri = request.getRequestURI();
        if (context != null && context.length() > 0) {
            return uri.substring(context.length());
        }
        return uri;
    }

    private void setFailureHeader(HttpServletResponse response, String message) {
        response.setHeader("X-Seraph-Trusted-App-Status", "ERROR");
        response.addHeader("X-Seraph-Trusted-App-Error", message);
        if (log.isInfoEnabled()) {
            log.info((Object)message, (Throwable)new RuntimeException(message));
        }
    }

    public void init(FilterConfig config) {
        this.filterConfig = config;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.init(filterConfig);
        }
    }

    private static boolean isBlank(String input) {
        return input == null || input.trim().length() == 0;
    }

    private static void notNull(String name, Object notNull) {
        if (notNull == null) {
            throw new IllegalArgumentException(name + " should not be null");
        }
    }

    static class AuthenticatorImpl
    implements Authenticator {
        final TrustedApplicationsManager appManager;
        final UserResolver resolver;
        final RoleMapper roleMapper;

        AuthenticatorImpl(TrustedApplicationsManager appManager, UserResolver resolver, RoleMapper roleMapper) {
            this.appManager = appManager;
            this.resolver = resolver;
            this.roleMapper = roleMapper;
        }

        public Authenticator.Result authenticate(HttpServletRequest request) {
            ApplicationCertificate certificate;
            Integer protocolVersion;
            String certStr = request.getHeader("X-Seraph-Trusted-App-Cert");
            if (TrustedApplicationsFilter.isBlank(certStr)) {
                return new Authenticator.Result.NoAttempt();
            }
            String id = request.getHeader("X-Seraph-Trusted-App-ID");
            if (TrustedApplicationsFilter.isBlank(id)) {
                return new Authenticator.Result.Error(new TransportErrorMessage.ApplicationIdNotFoundInRequest());
            }
            String key = request.getHeader("X-Seraph-Trusted-App-Key");
            if (TrustedApplicationsFilter.isBlank(key)) {
                return new Authenticator.Result.Error(new TransportErrorMessage.SecretKeyNotFoundInRequest());
            }
            String magicNumber = request.getHeader("X-Seraph-Trusted-App-Magic");
            String version = request.getHeader("X-Seraph-Trusted-App-Version");
            try {
                protocolVersion = !TrustedApplicationsFilter.isBlank(version) ? new Integer(version) : null;
            }
            catch (NumberFormatException e) {
                return new Authenticator.Result.Error(new TransportErrorMessage.BadProtocolVersion(version));
            }
            if (protocolVersion != null && TrustedApplicationsFilter.isBlank(magicNumber)) {
                return new Authenticator.Result.Error(new TransportErrorMessage.MagicNumberNotFoundInRequest());
            }
            TrustedApplication app = this.appManager.getTrustedApplication(id);
            if (app == null) {
                return new Authenticator.Result.Failure(new TransportErrorMessage.ApplicationUnknown(id));
            }
            try {
                certificate = app.decode(new DefaultEncryptedCertificate(id, key, certStr, protocolVersion, magicNumber), request);
            }
            catch (InvalidCertificateException ex) {
                log.warn((Object)("Failed to login trusted application: " + app.getID() + " due to: " + ex));
                log.debug((Object)"Failed to login trusted application cause", (Throwable)ex);
                return new Authenticator.Result.Error(ex.getTransportErrorMessage());
            }
            Principal user = this.resolver.resolve(certificate);
            if (user == null) {
                log.warn((Object)("User '" + certificate.getUserName() + "' referenced by trusted application: '" + app.getID() + "' is not found."));
                return new Authenticator.Result.Failure(new TransportErrorMessage.UserUnknown(certificate.getUserName()));
            }
            if (!this.roleMapper.canLogin(user, request)) {
                log.warn((Object)("User '" + certificate.getUserName() + "' referenced by trusted application: '" + app.getID() + "' cannot login."));
                return new Authenticator.Result.Failure(new TransportErrorMessage.PermissionDenied());
            }
            return new Authenticator.Result.Success(user);
        }
    }

    static interface Authenticator {
        public Result authenticate(HttpServletRequest var1);

        public static class Result {
            private final Status status;
            private final TransportErrorMessage message;
            private final Principal user;

            Result(Status status) {
                this(status, null, null);
            }

            Result(Status status, TransportErrorMessage message) {
                this(status, message, null);
                TrustedApplicationsFilter.notNull("message", message);
            }

            Result(Status status, Principal principal) {
                this(status, null, principal);
                TrustedApplicationsFilter.notNull("principal", principal);
            }

            Result(Status status, TransportErrorMessage message, Principal user) {
                if (status == null) {
                    throw new IllegalArgumentException("status");
                }
                this.status = status;
                this.message = message;
                this.user = user;
            }

            public Status getStatus() {
                return this.status;
            }

            public String getMessage() {
                return this.message.toString();
            }

            public Principal getUser() {
                return this.user;
            }

            static class Success
            extends Result {
                public Success(Principal principal) {
                    super(Status.SUCCESS, principal);
                }
            }

            static class Failure
            extends Result {
                Failure(TransportErrorMessage message) {
                    super(Status.FAILED, message);
                }
            }

            static class Error
            extends Result {
                Error(TransportErrorMessage message) {
                    super(Status.ERROR, message);
                }
            }

            static class NoAttempt
            extends Result {
                NoAttempt() {
                    super(Status.NO_ATTEMPT);
                }
            }

            static final class Status {
                static final Status SUCCESS = new Status(0, "success");
                static final Status FAILED = new Status(1, "failed");
                static final Status ERROR = new Status(2, "error");
                static final Status NO_ATTEMPT = new Status(3, "no attempt");
                private final int ordinal;
                private final String name;

                private Status(int ordinal, String name) {
                    this.ordinal = ordinal;
                    this.name = name;
                }

                int getOrdinal() {
                    return this.ordinal;
                }

                public String toString() {
                    return this.name;
                }

                static final class Constants {
                    static final int SUCCESS = 0;
                    static final int FAILED = 1;
                    static final int ERROR = 2;
                    static final int NO_ATTEMPT = 3;

                    Constants() {
                    }
                }
            }
        }
    }

    static class CertificateServerImpl
    implements CertificateServer {
        final TrustedApplicationsManager appManager;

        CertificateServerImpl(TrustedApplicationsManager appManager) {
            this.appManager = appManager;
        }

        public void writeCertificate(Writer writer) throws IOException {
            CurrentApplication currentApplication = this.appManager.getCurrentApplication();
            PublicKey publicKey = currentApplication.getPublicKey();
            try {
                writer.write(currentApplication.getID());
                writer.write("\n");
                byte[] key = publicKey.getEncoded();
                writer.write(new String(Base64.encode((byte[])key), "utf-8"));
                writer.write("\n");
                writer.write(TrustedApplicationUtils.Constant.VERSION.toString());
                writer.write("\n");
                writer.write(TrustedApplicationUtils.Constant.MAGIC);
                writer.flush();
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)ex);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static interface CertificateServer {
        public void writeCertificate(Writer var1) throws IOException;
    }

    private static final class Status {
        static final String ERROR = "ERROR";
        static final String OK = "OK";

        private Status() {
        }
    }
}

