@echo off


@setlocal

set FISHEYE_HOME=%~dp0..

if exist "%FISHEYE_HOME%\fisheyeboot.jar" goto haveFishEye

echo Could not find "%FISHEYE_HOME%\fisheyeboot.jar"
goto end

:haveFishEye



set _JAVACMD=%JAVACMD%

if not defined JAVA_HOME goto noJavaHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
if not defined _JAVACMD set _JAVACMD=%JAVA_HOME%\bin\java.exe

if exist "%_JAVACMD%" goto haveJava
echo Could not find "%_JAVACMD%", please set JAVA_HOME or JAVACMD,
echo or ensure java.exe is in the PATH.
goto end

:noJavaHome
if "%_JAVACMD%" == "" set _JAVACMD=java.exe

:haveJava

if "%FISHEYE_INST%" == "" set FISHEYE_INST=%FISHEYE_HOME%

set _EXECCMD="%_JAVACMD%"
if "%1" == "start" goto doStart
goto doExec

:doStart
set _EXECCMD=start "FishEye" "%_JAVACMD%"

:doExec
%_EXECCMD% %FISHEYE_OPTS% "-Dfisheye.library.path=%FISHEYE_LIBRARY_PATH%" "-Dfisheye.inst=%FISHEYE_INST%" -Djava.awt.headless=true "-Djava.endorsed.dirs=%FISHEYE_HOME%\lib\endorsed" -jar "%FISHEYE_HOME%\fisheyeboot.jar" %* %FISHEYE_ARGS%
if "%1" == "start" goto end
if errorlevel 1 pause
goto end


:end
rem all done

@endlocal


