function showRepoAttribs(repo){
    var storeDiffTrueElt = document.getElementById('repository.storeDifftrue');
    var storeDiffFalseElt = document.getElementById('repository.storeDifffalse');
    var cvsDiv = document.getElementById('cvsFields'), svnDiv = document.getElementById('svnFields')
    var p4Div = document.getElementById('p4Fields'), selection = repo.options[repo.selectedIndex].value;
    if (selection == "CVS"){
        cvsDiv.style.display = '';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        storeDiffTrueElt.disabled = true;
        storeDiffFalseElt.disabled = true;
    }
    if (selection == "SVN"){
        cvsDiv.style.display = 'none';
        svnDiv.style.display = '';
        p4Div.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    }
    if (selection == "P4"){
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = '';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    }
}

function svnSymDelRowEvent(a) {
    var tr = a.parentNode.parentNode;
    tr.parentNode.removeChild(tr);
    svnSymSetToCustom();
}
function svnSymAddRowEvent(stype) {
    svnSymAddRow(stype, false);
    svnSymSetToCustom();
}
function svnSymAddRow(stype, readonlyFields) {


    var tabBody = document.getElementById('svnsym' + stype);
    var idx = tabBody.getElementsByTagName("tr").length;

    var propPrefix = "svnSymbolic." + stype + "[" + idx + "]"

    var makesvnSymField = function(prop) {
        var field = document.createElement("input");
        field.type="text";
        field.name=propPrefix + prop;
        field.size="20";
        field.readOnly=readonlyFields;

        return field;
    };

    var newrow = document.createElement("tr");

    var addToRow = function(field) {
        var td = document.createElement("td");
        td.appendChild(field);
        newrow.appendChild(td);
    }

    var f1 = makesvnSymField(".regex");
    addToRow(f1);

    var f2 = makesvnSymField(".name");
    addToRow(f2);

    var f3 = makesvnSymField(".logical");
    addToRow(f3);

    var delAnchor = document.createElement("a");
    delAnchor.innerHTML = "Del";
    delAnchor.href = "#svnSymAnchor";
    delAnchor.onclick=function() {svnSymDelRowEvent(delAnchor);}
    addToRow(delAnchor);

    tabBody.appendChild(newrow);

    var result = {
            'regex': f1, 'name': f2, 'logical':f3
    };
    return result;
}

function svnSymSetToCustom() {
    var sel = document.getElementById("svnSymSelect");
    sel.value = "custom";
    svnSymTypeChange(sel);
}

function svnSymUpdateControls(body, readonly) {
    var fields = body.getElementsByTagName("input");
    for (var i = 0; i < fields.length; i++) {
        var f = fields[i];
        f.readOnly = false;
    }
}

function svnSymSetupRow(fields, reg, name, logical) {
    fields['regex'].value = reg;
    fields['name'].value = name;
    fields['logical'].value = logical;
}

function svnRemoveAllRows(svnParent) {
    var svnChildren = svnParent.rows;
    for (var i = 0; i < svnChildren.length; i++) {
        svnParent.removeChild(svnChildren[i]);
    }
}

function svnSymTypeChange(select) {
    var trunkd = document.getElementById('svnsymtrunk');
    var branchd = document.getElementById('svnsymbranch');
    var tagd = document.getElementById('svnsymtag');

    if (select.value == "custom") {
        svnSymUpdateControls(trunkd, false);
        svnSymUpdateControls(branchd, false);
        svnSymUpdateControls(tagd, false);
        return true;
    }

    svnRemoveAllRows(trunkd);
    svnRemoveAllRows(branchd);
    svnRemoveAllRows(tagd);

    if (select.value == "type1") {

        svnSymSetupRow(svnSymAddRow('trunk', true), "trunk(/|$)", "trunk", "");
        svnSymSetupRow(svnSymAddRow('branch', true), "branches/([^/]+)", "\${1}", "");
        svnSymSetupRow(svnSymAddRow('tag', true), "tags/([^/]+)", "\${1}", "");

    } else if (select.value == "type2") {

        svnSymSetupRow(svnSymAddRow('trunk', true), "([^/]+)/trunk(/|$)", "trunk", "\${1}");
        svnSymSetupRow(svnSymAddRow('branch', true), "([^/]+)/branches/([^/]+)", "\${1}-\${2}", "\${1}");
        svnSymSetupRow(svnSymAddRow('tag', true), "([^/]+)/tags/([^/]+)", "\${1}-\${2}", "\${1}");

    }
    return true;
}

// copied from crucibles global.js
function simpleSwap(toHide,toShow) {
  simpleSwapHelper(toHide,toShow,'block');
}
function simpleSwapDefault(toHide,toShow) {
  simpleSwapHelper(toHide,toShow,'');
}
function simpleSwapInline(toHide,toShow) {
  simpleSwapHelper(toHide,toShow,'inline');
}
function simpleSwapHelper(toHide,toShow,displayValue) {
  if (typeof(toHide) == 'object') {
    toHide.style.display = 'none';
  } else {
    document.getElementById(toHide).style.display = 'none';
  }
  if (typeof(toShow) == 'object') {
    toShow.style.display = displayValue;
  } else {
    document.getElementById(toShow).style.display = displayValue;
  }
}