/*
 * 	Ruleset for Fisheye AJAX
 */

var dirtreePreviouslyOpened = {}; // map of parenturl to opened <ul> for each folder

var myrules = {
	// Expand+collapse rule for the subdirectory tree
	'.dirPane .expand' : function(e){
		e.onclick = function(){
            // Container of the folder icon
			var p = this.parentNode;

            // Get the URL of the subdirectory from the last <a href="..." /> tag
            var as = p.getElementsByTagName("a");
            var a = as[as.length - 1];
            var url = a.href;

            if (!this.src.match(/_open/)){
				// Open the subfolder
				e.src = fishEyePageContext + "/" + fishEyeSTATICDIR + "/images/folder_open.gif";

                if (dirtreePreviouslyOpened[url] == null) {
                    // Create the container for the subfolder
                    var ul = document.createElement("ul");
                    ul.innerHTML = "<li><img style='margin-left: 20px' src='" + fishEyePageContext + "/" + fishEyeSTATICDIR + "/images/spinner.gif' /></li>";
                    dirtreePreviouslyOpened[url] = ul;

                    // Add the subfolder to the document tree
                    p.parentNode.insertBefore(ul, p.nextSibling);

                    if (url.match(/\?/)) {
                        url = url + "&";
                    } else {
                        url = url + "?";
                    }
                    url = url + "dirtreefragrender=true";

                    // Load the URL for the subdirectory using the Prototype
                    // library. Populate our new ul with the response.
                    new Ajax.Updater(ul, url, {
                        onComplete : function(){
                            // Apply behaviours to the newly added DOM
                            // objects.
                            Behaviour.apply();
                        }
                    });
                } else {
                    // previously opened, just un-hide it
                    var ul = dirtreePreviouslyOpened[url];
                    ul.style.display = "";
                }
            }else{
				// Close the subfolder
				e.src = fishEyePageContext + "/" + fishEyeSTATICDIR + "/images/folder_closed.gif";
                var ul = dirtreePreviouslyOpened[url];
                ul.style.display = "none";
			}
		}
	}
};



Behaviour.start();
Behaviour.register(myrules);

