function csExpandDiff(revId, url) {
    csLoadDiff(revId, url);
    csDiffToggle(revId);
}

var csDiffMap = $H();

// from http://www.quirksmode.org/js/cookies.html
function readCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0;i < ca.length;i++) {
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}

/*
 * usefull for appending to urls (esp ajax urls) when the content of the
 * url depends on the user's cookie preferences
 */
function getCookiePrefToken() {
    try {
        var val = readCookie("crucibleprefs1")
        if (val) {
            val = val.replace(/^D=[0-9]+/, "");
            return encodeURIComponent(val);
        }
    } catch(ex) {
    }
    return "unknown"
}

function csLoadDiff(revId, url, onCompleteFunc) {
    if (!csDiffMap[revId]) {
        var params = 'revid=' + revId + "&rndtmp=" + getCookiePrefToken();
        var divId = csDisplaySpinner(revId);
        csDiffMap[revId] = true;
        new Ajax.Updater(divId, url,
        {onComplete: onCompleteFunc, method: 'get', parameters: params, asynchronous: true});
    } else {
        if (onCompleteFunc) {
            onCompleteFunc();
        }
    }
}

function csLoadAsyncDiff(i, url, revIds) {
    var onComp = function(origRequest) {
        // do the chaining.
        csLoadAsyncDiff(i + 1, url, revIds);
    }
    if ((i < revIdsToDiff.length) && (i < 100)) {
        var revId = revIds[i];
        csLoadDiff(revId, url, onComp);
    }
}

function csDisplaySpinner(revId) {
    var spinnerHTML = "<img src='" + fishEyePageContext + "/" + fishEyeSTATICDIR + "/images/spinner.gif'/> <span class='loading'>Loading content</span>";
    var divId = csGetCsDivId(revId);
    var divEle = $(divId);
    divEle.innerHTML = spinnerHTML;
    return divId;
}

function csGetCsDivId(revId) {
    return 'showfilesDiv' + revId;
}