var tabview = true;
var sticky = false;
var vistab;
var vispage;

function showTab(obj,ref){
    if (vistab){
        vistab.style.backgroundColor = '#dddddd';
        vistab.style.top = '';
        vistab.style.zIndex = 1;
        vispage.style.display = 'none';
    }
    div = $(ref);
    div.style.display = '';
    vistab = obj;
    vistab.style.backgroundColor = '#ffffff';
    vistab.style.top = "+1px";
    vistab.style.zIndex = 3;
    vispage = div;
}

function popInfoOver(obj,commentId){
    if(!sticky){
        displayInfo(obj,commentId);
    }
}

function popInfoOut(obj){
    if(!sticky){
        hideInfo(obj);
    }
}

function popInfoClick(obj,commentId){
    if(sticky == false){
        sticky = true;
        displayInfo(obj,commentId);
        pin(obj);
    } else {
        unpin(obj);
        hideInfo(obj);
        sticky = false;
    }
    return false;
}

function unpinInfo(obj){
    sticky = false;
    unpin(obj);
    hideInfo(obj);
    return false;
}

var displayInfoCache = new Array();
var displayInfoShowing;
function displayInfo(obj,commentId){
    if(displayInfoShowing == obj){
        $('commentInfoDiv').style.display = '';
        return;
    }
    displayInfoShowing = obj;

    if(displayInfoCache[commentId]){
        template = displayInfoCache[commentId];
    } else {
        template = displayGroupComment(commentId,'groupCommentTemplate');
        displayInfoCache[commentId] = template;
    }
    info = $('commentInfoDiv');
    con =$('cidContent');
    con.innerHTML = template;
    setLayerPos(obj,info);
	info.style.display = '';
}

function hideInfo(obj){
	info = $('commentInfoDiv');
	info.style.display = 'none';
}

function pin(obj){
	$('pininfo').style.display = '';
	$('unpininfo').style.display = 'none';
}

function unpin(obj){
	$('pininfo').style.display = 'none';
	$('unpininfo').style.display = '';
}

function setLayerPos(obj,layer)
{
	var newX = findPosX(obj);
	var newY = findPosY(obj)+20;
	layer.style.top = newY + 'px';
	layer.style.left = newX + 'px';
}

function findPosX(obj)
{
	var curleft = 0;
    if (obj.nodeName == 'INPUT'){
        curleft += obj.offsetLeft;
    }
    else if (obj.offsetParent)
	{
		while (obj)
		{
			curleft += obj.offsetLeft
			obj = obj.offsetParent;
		}
	}
	else if (obj.x)
		curleft += obj.x;
	return curleft;
}

function findPosY(obj)
{
	var curtop = 0;
    if (obj.nodeName == 'INPUT'){
        curtop += obj.offsetTop;
    }
    else if (obj.offsetParent)
	{
		while (obj)
		{
			curtop += obj.offsetTop
			obj = obj.offsetParent;
        }
	}
	else if (obj.y){
		curtop += obj.y;
    }
    return curtop;
}

function dropDownList(el){
    var prevInput = getPrevInput(el);
    var newX = findPosX(prevInput);
    var newY = findPosY(prevInput)+prevInput.offsetHeight;
    nextDiv = getNextDiv(el);
    nextDiv.style.top = newY + 'px';
    nextDiv.style.left = newX + 'px';
//    nextDiv.style.width = prevInput.offsetWidth;
    nextDiv.style.display='';
}

function getPrevInput(el){
    var prev = el.previousSibling;
    while(prev != null){
        if(prev.nodeName == 'INPUT'){
            return prev;
        }
        prev = prev.previousSibling;
    }
}

function getNextDiv(el){
    var next = el.nextSibling;
    while(next != null){
        if(next.nodeName == "DIV"){
            return next;
        }
        next = next.nextSibling;
    }
}

function hideParent(el){
    el.parentNode.style.display='none';
}