[#ftl]
[#include "fisheye-mail-subject.ftl"]

[#setting time_zone="${timezone}"]
<html>
<body>
[#include "fisheye-mail-header.ftl"]
[#list changesets as cs]
<table width="100%">
 <tr>
  <td><a href="${siteurl}changelog/${repname}?cs=${cs.id}"><strong>${cs.id}</strong></a></td>
  <td width="30%" align="center"><strong>${cs.author}</strong></td>
  <td align="right">${cs.dateValue?string("EEE, dd MMMM yyyy, HH:mm:ss ZZ")}</td>
 </tr>
 <tr><td colspan="3">
  <hr />

  <tt>${commentFormatter.format(repcfg, cs.comment)}</tt>
 <hr />
 </td></tr>
</table>
<table>
[#list cs.revisionInfos as rev]
<tr>
  <td><a href="${siteurl}browse/${repname}/${urlEncoder.encode(rev.path)}">${rev.path}</a></td>
  <td><a href="${siteurl}browse/${repname}/${urlEncoder.encode(rev.path)}?r=${rev.revision}">${rev.revision}</a></td>
  [#if rev.binary]
  <td>binary</td>
  <td><a href="${siteurl}browse/~raw,r=${rev.revision}/${repname}/${urlEncoder.encode(rev.path)}">raw</a></td>
  [#else]
  <td>([#if !rev.dead]+${rev.linesAdded}[/#if][#if !rev.added]-${rev.linesRemoved}[/#if])</td>
  [/#if]
  [#if rev.dead]
  <td><em>deleted[#if rev.move]/moved[/#if][#if rev.copy]/copied[/#if]</em></td>
  [#elseif rev.added]
  <td><em>new[#if rev.move]/moved[/#if][#if rev.copy]/copied[/#if]</em></td>
  [#elseif rev.ancestorRevision?exists]
  <td><a href="${siteurl}browse/${repname}/${urlEncoder.encode(rev.path)}?r1=${rev.ancestorRevision}&r2=${rev.revision}">diffs</a></td>
  [/#if]
</tr>
[/#list]
</table>
<br/>
<br/>
[/#list]
<a href="${siteurl}profile/showWatches.do">show watches</a>
<hr />
[#include "fisheye-mail-footer.ftl"]
</body>
</html>

