/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil;

import clover.it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import clover.it.unimi.dsi.fastutil.IndirectPriorityQueues;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class IndirectDoublePriorityQueues {
    public static final EmptyIndirectDoublePriorityQueue EMPTY_QUEUE = new EmptyIndirectDoublePriorityQueue();

    private IndirectDoublePriorityQueues() {
    }

    public static IndirectDoublePriorityQueue synchronize(IndirectDoublePriorityQueue q) {
        return new SynchronizedIndirectDoublePriorityQueue(q);
    }

    public static IndirectDoublePriorityQueue synchronize(IndirectDoublePriorityQueue q, Object sync) {
        return new SynchronizedIndirectDoublePriorityQueue(q, sync);
    }

    public static class SynchronizedIndirectDoublePriorityQueue
    implements IndirectDoublePriorityQueue {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final IndirectDoublePriorityQueue q;
        protected final Object sync;

        protected SynchronizedIndirectDoublePriorityQueue(IndirectDoublePriorityQueue q, Object sync) {
            this.q = q;
            this.sync = sync;
        }

        protected SynchronizedIndirectDoublePriorityQueue(IndirectDoublePriorityQueue q) {
            this.q = q;
            this.sync = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(int x) {
            Object object = this.sync;
            synchronized (object) {
                this.q.enqueue(x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int dequeue() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int first() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int last() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.last();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int secondaryFirst() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.secondaryFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int secondaryLast() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.secondaryLast();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.sync;
            synchronized (object) {
                this.q.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed() {
            Object object = this.sync;
            synchronized (object) {
                this.q.changed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void allChanged() {
            Object object = this.sync;
            synchronized (object) {
                this.q.allChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(int i) {
            Object object = this.sync;
            synchronized (object) {
                this.q.changed(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(int i) {
            Object object = this.sync;
            synchronized (object) {
                this.q.remove(i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator secondaryComparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.q.secondaryComparator();
            }
        }
    }

    public static class EmptyIndirectDoublePriorityQueue
    extends IndirectPriorityQueues.EmptyIndirectPriorityQueue {
        protected EmptyIndirectDoublePriorityQueue() {
        }

        public int secondaryFirst() {
            throw new NoSuchElementException();
        }

        public int secondaryLast() {
            throw new NoSuchElementException();
        }

        public Comparator secondaryComparator() {
            return null;
        }
    }
}

