/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import clover.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2DoubleMap
implements Long2DoubleMap,
Serializable {
    protected double defRetValue;

    protected AbstractLong2DoubleMap() {
    }

    public void setDefRetValue(double rv) {
        this.defaultReturnValue(rv);
    }

    public double getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(double rv) {
        this.defRetValue = rv;
    }

    public double defaultReturnValue() {
        return this.defRetValue;
    }

    public double put(long key, double value) {
        throw new UnsupportedOperationException();
    }

    public double remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? new Double(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        double v = this.put(k, (Double)ov);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        double v = this.remove(k);
        return this.containsKey(k) ? new Double(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Double)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(double v) {
        return ((DoubleCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2DoubleMap) {
            while (n-- != 0) {
                Long2DoubleMap.Entry e = (Long2DoubleMap.Entry)i.next();
                this.put(e.getLongKey(), e.getDoubleValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2DoubleMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2DoubleMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2DoubleMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2DoubleMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractDoubleCollection(){

            public boolean contains(double k) {
                return AbstractLong2DoubleMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2DoubleMap.this.size();
            }

            public DoubleIterator doubleIterator() {
                return new AbstractDoubleIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2DoubleMap.this.entrySet().iterator();
                    }

                    public double nextDouble() {
                        return ((Long2DoubleMap.Entry)this.i.next()).getDoubleValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Long2DoubleMap.Entry first = (Long2DoubleMap.Entry)i.next();
            s.append(String.valueOf(first.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(first.getDoubleValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2DoubleMap.Entry {
        protected long key;
        protected double value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = (Double)value;
        }

        public BasicEntry(long key, double value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Double(this.value);
        }

        public double getDoubleValue() {
            return this.value;
        }

        public double setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Double(this.setValue((Double)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Double)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ HashCommon.double2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

