/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Hash;
import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.ByteArrays;
import clover.it.unimi.dsi.fastutil.doubles.AbstractDoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import clover.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObject2DoubleMap;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Object2DoubleOpenCustomHashMap
extends AbstractObject2DoubleMap
implements Serializable,
Cloneable,
Hash,
Object2DoubleMap {
    protected transient Object[] key;
    protected transient double[] value;
    protected transient byte[] state;
    protected final float f;
    protected transient int p;
    protected transient int maxFill;
    protected transient int free;
    protected int count;
    protected volatile transient ObjectSet entries;
    protected volatile transient ObjectSet keys;
    protected volatile transient DoubleCollection values;
    protected transient int growthFactor = 16;
    protected Hash.Strategy strategy;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;

    public Object2DoubleOpenCustomHashMap(int n, float f, Hash.Strategy strategy) {
        this.strategy = strategy;
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Hash table size must be nonnegative");
        }
        int l = Arrays.binarySearch(PRIMES, (int)((float)n / f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        this.p = l;
        this.free = PRIMES[this.p];
        this.f = f;
        this.maxFill = (int)((float)this.free * f);
        this.key = new Object[this.free];
        this.value = new double[this.free];
        this.state = new byte[this.free];
    }

    public Object2DoubleOpenCustomHashMap(int n, Hash.Strategy strategy) {
        this(n, 0.75f, strategy);
    }

    public Object2DoubleOpenCustomHashMap(Hash.Strategy strategy) {
        this(16, 0.75f, strategy);
    }

    public Object2DoubleOpenCustomHashMap(Map m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll(m);
    }

    public Object2DoubleOpenCustomHashMap(Map m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2DoubleOpenCustomHashMap(Object2DoubleMap m, float f, Hash.Strategy strategy) {
        this(m.size(), f, strategy);
        this.putAll((Map)m);
    }

    public Object2DoubleOpenCustomHashMap(Object2DoubleMap m, Hash.Strategy strategy) {
        this(m, 0.75f, strategy);
    }

    public Object2DoubleOpenCustomHashMap(Object[] k, double[] v, float f, Hash.Strategy strategy) {
        this(k.length, f, strategy);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2DoubleOpenCustomHashMap(Object[] k, double[] v, Hash.Strategy strategy) {
        this(k, v, 0.75f, strategy);
    }

    public Hash.Strategy strategy() {
        return this.strategy;
    }

    public void growthFactor(int growthFactor) {
        if (growthFactor <= 0) {
            throw new IllegalArgumentException("Illegal growth factor " + growthFactor);
        }
        this.growthFactor = growthFactor;
    }

    public int growthFactor() {
        return this.growthFactor;
    }

    private int findInsertionPoint(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] != -1 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        if (state[h1] == 0) {
            return h1;
        }
        if (state[h1] == -1) {
            return -h1 - 1;
        }
        int i = h1;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? -h1 - 1 : i;
    }

    private int findKey(Object k) {
        Object[] key = this.key;
        byte[] state = this.state;
        int n = key.length;
        int h = this.strategy.hashCode(k);
        int k2i = h & Integer.MAX_VALUE;
        int h1 = k2i % n;
        if (!(state[h1] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            int h2 = k2i % (n - 2) + 1;
            while (!(state[h1 = (h1 + h2) % n] == 0 || h == this.strategy.hashCode(key[h1]) && this.strategy.equals(k, key[h1]))) {
            }
        }
        return state[h1] == -1 ? h1 : -1;
    }

    public double put(Object k, double v) {
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            double oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return oldValue;
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            int n = Math.min(this.p + this.growthFactor, PRIMES.length - 1);
            while (PRIMES[n] == PRIMES[this.p]) {
                ++n;
            }
            this.rehash(n);
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return this.defRetValue;
    }

    public Object put(Object ok, Object ov) {
        double v = (Double)ov;
        Object k = ok;
        int i = this.findInsertionPoint(k);
        if (i < 0) {
            double oldValue = this.value[-i - 1];
            this.value[-i - 1] = v;
            return new Double(oldValue);
        }
        if (this.state[i] == 0) {
            --this.free;
        }
        this.state[i] = -1;
        this.key[i] = k;
        this.value[i] = v;
        if (++this.count >= this.maxFill) {
            this.rehash(Math.min(this.p + 16, PRIMES.length - 1));
        }
        if (this.free == 0) {
            this.rehash(this.p);
        }
        return null;
    }

    public boolean containsValue(double v) {
        double[] value = this.value;
        byte[] state = this.state;
        int i = 0;
        int j = this.count;
        while (j-- != 0) {
            while (state[i] != -1) {
                ++i;
            }
            if (value[i] == v) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        if (this.free == this.state.length) {
            return;
        }
        this.free = this.state.length;
        this.count = 0;
        ByteArrays.fill((byte[])this.state, (byte)0);
        ObjectArrays.fill(this.key, null);
    }

    public boolean containsKey(Object k) {
        return this.findKey(k) >= 0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public double getDouble(Object k) {
        int i = this.findKey(k);
        return i < 0 ? this.defRetValue : this.value[i];
    }

    public double removeDouble(Object k) {
        int i = this.findKey(k);
        if (i < 0) {
            return this.defRetValue;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return this.value[i];
    }

    public Object get(Object ok) {
        int i = this.findKey(ok);
        return i < 0 ? null : new Double(this.value[i]);
    }

    public Object remove(Object ok) {
        Object k = ok;
        int i = this.findKey(k);
        if (i < 0) {
            return null;
        }
        this.state[i] = 1;
        --this.count;
        this.key[i] = HashCommon.REMOVED;
        return new Double(this.value[i]);
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new MapIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2DoubleOpenCustomHashMap.this.findKey(e.getKey());
                    return i >= 0 && Object2DoubleOpenCustomHashMap.this.value[i] == (Double)e.getValue();
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    int i = Object2DoubleOpenCustomHashMap.this.findKey(e.getKey());
                    if (i >= 0) {
                        Object2DoubleOpenCustomHashMap.this.remove(e.getKey());
                    }
                    return i >= 0;
                }

                public int size() {
                    return Object2DoubleOpenCustomHashMap.this.count;
                }

                public void clear() {
                    Object2DoubleOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractDoubleCollection(){

                public DoubleIterator doubleIterator() {
                    return new ValueIterator();
                }

                public int size() {
                    return Object2DoubleOpenCustomHashMap.this.count;
                }

                public boolean contains(double v) {
                    return Object2DoubleOpenCustomHashMap.this.containsValue(v);
                }

                public void clear() {
                    Object2DoubleOpenCustomHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public boolean rehash() {
        try {
            this.rehash(this.p);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim() {
        int l = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (l >= this.p) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = Arrays.binarySearch(PRIMES, (int)Math.min(2.1474836E9f, (float)Math.max(n, this.count) / this.f) + 1);
        if (l < 0) {
            l = -l - 1;
        }
        if (this.p <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newP) {
        int i = 0;
        int j = this.count;
        int n = PRIMES[newP];
        Object[] objectArray = this.key;
        Object[] objectArray2 = new Object[n];
        double[] dArray = this.value;
        double[] dArray2 = new double[n];
        byte[] byArray = this.state;
        byte[] newN = new byte[n];
        while (j-- != 0) {
            void k2i;
            void k;
            while (byArray[i] != -1) {
                ++i;
            }
            Object key = objectArray[i];
            void var12_12 = k[i];
            int newValue = this.strategy.hashCode(key) & Integer.MAX_VALUE;
            int state = newValue % k2i;
            int newState = newValue % (k2i - 2) + 1;
            if (newN[state] != 0) {
                newState = newValue % (k2i - 2) + 1;
                while (newN[state = (state + newState) % k2i] != 0) {
                }
            }
            newN[state] = -1;
            h2[state] = key;
            dArray2[state] = var12_12;
            ++i;
        }
        this.p = newP;
        this.free = n - this.count;
        this.maxFill = (int)((float)n * this.f);
        this.key = objectArray2;
        this.value = dArray2;
        this.state = newN;
    }

    public Object clone() {
        Object2DoubleOpenCustomHashMap c;
        try {
            c = (Object2DoubleOpenCustomHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (double[])this.value.clone();
        c.state = (byte[])this.state.clone();
        c.strategy = this.strategy;
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        int h = 0;
        int n = 0;
        int i = this.count;
        while (i-- != 0) {
            void t;
            while (this.state[n] != -1) {
                ++n;
            }
            int j = 0;
            if (this != this.key[t]) {
                j = this.strategy.hashCode(this.key[t]);
            }
            h += (j ^= HashCommon.double2int(this.value[t]));
            ++t;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object[] key = this.key;
        double[] value = this.value;
        byte[] state = this.state;
        MapIterator i = new MapIterator();
        int n = this.count;
        s.defaultWriteObject();
        while (n-- != 0) {
            int j = i.nextEntry();
            s.writeObject(key[j]);
            s.writeDouble(value[j]);
        }
    }

    private void checkTable() {
        int n = this.state.length;
        while (n-- != 0) {
            if (this.state[n] == -1 && !this.containsKey(this.key[n])) {
                throw new AssertionError((Object)("Hash table has key " + this.key[n] + " marked as occupied, but the key does not belong to the table"));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.growthFactor = 16;
        this.p = Arrays.binarySearch(PRIMES, (int)((float)this.count / this.f) + 1);
        if (this.p < 0) {
            this.p = -this.p - 1;
        }
        int n = PRIMES[this.p];
        this.maxFill = (int)((float)n * this.f);
        this.free = n - this.count;
        this.key = new Object[n];
        Object[] key = this.key;
        this.value = new double[n];
        double[] value = this.value;
        this.state = new byte[n];
        byte[] state = this.state;
        int i = this.count;
        while (i-- != 0) {
            void k2i;
            Object object = s.readObject();
            double d = s.readDouble();
            int k = this.strategy.hashCode(object) & Integer.MAX_VALUE;
            int n2 = k % n;
            if (state[n2] != 0) {
                int n3 = k % (n - 2) + 1;
                while (state[n2 = (n2 + n3) % n] != 0) {
                }
            }
            state[n2] = -1;
            key[n2] = k2i;
            value[n2] = d;
        }
    }

    private final class ValueIterator
    extends MapIterator
    implements DoubleIterator {
        public double nextDouble() {
            return Object2DoubleOpenCustomHashMap.this.value[this.nextEntry()];
        }

        public Object next() {
            return new Double(Object2DoubleOpenCustomHashMap.this.value[this.nextEntry()]);
        }

        public void set(double v) {
            throw new UnsupportedOperationException();
        }

        public void add(double v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeySet
    extends AbstractObjectSet {
        private KeySet() {
        }

        public ObjectIterator objectIterator() {
            return new KeyIterator();
        }

        public int size() {
            return Object2DoubleOpenCustomHashMap.this.count;
        }

        public boolean contains(Object k) {
            return Object2DoubleOpenCustomHashMap.this.containsKey(k);
        }

        public boolean remove(Object k) {
            int oldCount = Object2DoubleOpenCustomHashMap.this.count;
            Object2DoubleOpenCustomHashMap.this.remove(k);
            return Object2DoubleOpenCustomHashMap.this.count != oldCount;
        }

        public void clear() {
            Object2DoubleOpenCustomHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator {
        public Object next() {
            return Object2DoubleOpenCustomHashMap.this.key[this.nextEntry()];
        }

        public void set(Object k) {
            throw new UnsupportedOperationException();
        }

        public void add(Object k) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator
    extends AbstractObjectIterator {
        int pos = 0;
        int last = -1;
        int c;

        private MapIterator() {
            this.c = Object2DoubleOpenCustomHashMap.this.count;
            byte[] state = Object2DoubleOpenCustomHashMap.this.state;
            int n = state.length;
            if (this.c != 0) {
                while (this.pos < n && state[this.pos] != -1) {
                    ++this.pos;
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0 && this.pos < Object2DoubleOpenCustomHashMap.this.state.length;
        }

        public int nextEntry() {
            byte[] state = Object2DoubleOpenCustomHashMap.this.state;
            int n = state.length;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                do {
                    ++this.pos;
                } while (this.pos < n && state[this.pos] != -1);
            }
            return this.last;
        }

        public Object next() {
            return new MapEntry(this.nextEntry());
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Object2DoubleOpenCustomHashMap.this.state[this.last] = 1;
            Object2DoubleOpenCustomHashMap.this.key[this.last] = HashCommon.REMOVED;
            --Object2DoubleOpenCustomHashMap.this.count;
        }
    }

    private final class MapEntry
    implements Object2DoubleMap.Entry {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        public Object getKey() {
            return Object2DoubleOpenCustomHashMap.this.key[this.index];
        }

        public Object getValue() {
            return new Double(Object2DoubleOpenCustomHashMap.this.value[this.index]);
        }

        public double getDoubleValue() {
            return Object2DoubleOpenCustomHashMap.this.value[this.index];
        }

        public double setValue(double v) {
            double oldValue = Object2DoubleOpenCustomHashMap.this.value[this.index];
            Object2DoubleOpenCustomHashMap.this.value[this.index] = v;
            return oldValue;
        }

        public Object setValue(Object v) {
            return new Double(this.setValue((Double)v));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Object2DoubleOpenCustomHashMap.this.strategy.equals(Object2DoubleOpenCustomHashMap.this.key[this.index], e.getKey()) && Object2DoubleOpenCustomHashMap.this.value[this.index] == (Double)e.getValue();
        }

        public int hashCode() {
            return Object2DoubleOpenCustomHashMap.this.strategy.hashCode(Object2DoubleOpenCustomHashMap.this.key[this.index]) ^ HashCommon.double2int(Object2DoubleOpenCustomHashMap.this.value[this.index]);
        }

        public String toString() {
            return Object2DoubleOpenCustomHashMap.this.key[this.index] + "->" + Object2DoubleOpenCustomHashMap.this.value[this.index];
        }
    }
}

