/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.Arrays;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectList;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterators;
import clover.it.unimi.dsi.fastutil.objects.ObjectList;
import clover.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class ObjectArrayList
extends AbstractObjectList
implements RandomAccess,
Cloneable,
Serializable {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected static final long ONEOVERPHI = 106039L;
    protected transient Object[] a;
    protected int size;
    public static final long serialVersionUID = -7046029254386353130L;
    private static final boolean ASSERTS = false;

    protected ObjectArrayList(Object[] a, boolean dummy) {
        this.a = a;
    }

    public ObjectArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new Object[capacity];
    }

    public ObjectArrayList() {
        this(16);
    }

    public ObjectArrayList(Collection c) {
        this(c.size());
        this.size = ObjectIterators.unwrap((Iterator)ObjectIterators.asObjectIterator(c.iterator()), this.a);
    }

    public ObjectArrayList(ObjectCollection c) {
        this(c.size());
        this.size = ObjectIterators.unwrap((Iterator)c.objectIterator(), this.a);
    }

    public ObjectArrayList(ObjectList l) {
        this(l.size());
        this.size = l.size();
        l.getElements(0, this.a, 0, this.size);
    }

    public ObjectArrayList(Object[] a) {
        this(a, 0, a.length);
    }

    public ObjectArrayList(Object[] a, int offset, int length) {
        this(length);
        System.arraycopy(a, offset, this.a, 0, length);
        this.size = length;
    }

    public ObjectArrayList(Iterator i) {
        this(ObjectIterators.asObjectIterator(i));
    }

    public ObjectArrayList(ObjectIterator i) {
        this();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public Object[] elements() {
        return this.a;
    }

    public static ObjectArrayList wrap(Object[] a, int length) {
        if (length > a.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
        }
        ObjectArrayList l = new ObjectArrayList(a, false);
        l.size = length;
        return l;
    }

    public static ObjectArrayList wrap(Object[] a) {
        return ObjectArrayList.wrap(a, a.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = ObjectArrays.ensureCapacity(this.a, capacity, this.size);
    }

    public void add(int index, Object k) {
        this.ensureIndex(index);
        this.a = ObjectArrays.grow(this.a, this.size + 1, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k;
        ++this.size;
    }

    public boolean add(Object k) {
        this.a = ObjectArrays.grow(this.a, this.size + 1, this.size);
        this.a[this.size++] = k;
        return true;
    }

    public boolean addAll(int index, ObjectCollection c) {
        this.ensureIndex(index);
        int n = c.size();
        if (n == 0) {
            return false;
        }
        this.a = ObjectArrays.grow(this.a, this.size + n, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        ObjectIterator i = c.objectIterator();
        this.size += n;
        while (n-- != 0) {
            this.a[index++] = i.next();
        }
        return true;
    }

    public boolean addAll(int index, ObjectList l) {
        this.ensureIndex(index);
        int n = l.size();
        if (n == 0) {
            return false;
        }
        this.a = ObjectArrays.grow(this.a, this.size + n, this.size);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n, this.size - index);
        }
        l.getElements(0, this.a, index, n);
        this.size += n;
        return true;
    }

    public boolean addAll(ObjectList l) {
        return this.addAll(this.size, l);
    }

    public Object get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    public int indexOf(Object k) {
        int h = k == null ? 0 : k.hashCode();
        for (int i = 0; i < this.size; ++i) {
            if (!(k == null ? this.a[i] == null : h == this.a[i].hashCode() && k.equals(this.a[i]))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object k) {
        int h = k == null ? 0 : k.hashCode();
        int i = this.size;
        while (i-- != 0) {
            if (!(k == null ? this.a[i] == null : h == this.a[i].hashCode() && k.equals(this.a[i]))) continue;
            return i;
        }
        return -1;
    }

    public Object remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        Object old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        this.a[this.size] = null;
        return old;
    }

    public boolean rem(Object k) {
        int index = this.indexOf(k);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public Object set(int index, Object k) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        Object old = this.a[index];
        this.a[index] = k;
        return old;
    }

    public void clear() {
        ObjectArrays.fill(this.a, 0, this.size, null);
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            for (int i = this.size; i < size; ++i) {
                this.a[i] = null;
            }
        } else {
            for (int i = size; i < this.size; ++i) {
                this.a[i] = null;
            }
        }
        this.size = size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n) {
        if (n >= this.a.length || this.size == this.a.length) {
            return;
        }
        Object[] t = new Object[Math.max(n, this.size)];
        System.arraycopy(this.a, 0, t, 0, this.size);
        this.a = t;
    }

    public void getElements(int from, Object[] a, int offset, int length) {
        ObjectArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
        int i = to - from;
        while (i-- != 0) {
            this.a[this.size + i] = null;
        }
    }

    public void addElements(int index, Object[] a, int offset, int length) {
        this.ensureIndex(index);
        ObjectArrays.ensureOffsetLength(a, offset, length);
        this.a = ObjectArrays.grow(this.a, this.size + length, this.size);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a, offset, this.a, index, length);
        this.size += length;
    }

    public ObjectListIterator objectListIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractObjectListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            public boolean hasNext() {
                return this.pos < ObjectArrayList.this.size;
            }

            public boolean hasPrevious() {
                return this.pos > 0;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return ObjectArrayList.this.a[this.last];
            }

            public Object previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return ObjectArrayList.this.a[this.pos];
            }

            public int nextIndex() {
                return this.pos;
            }

            public int previousIndex() {
                return this.pos - 1;
            }

            public void add(Object k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ObjectArrayList.this.add(this.pos++, k);
                this.last = -1;
            }

            public void set(Object k) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ObjectArrayList.this.set(this.last, k);
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                ObjectArrayList.this.remove(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public Object clone() {
        ObjectArrayList c = new ObjectArrayList(this.size);
        System.arraycopy(this.a, 0, c.a, 0, this.size);
        c.size = this.size;
        return c;
    }

    private boolean valEquals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(ObjectArrayList l) {
        if (l == this) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        Object[] a1 = this.a;
        Object[] a2 = l.a;
        while (s-- != 0) {
            if (this.valEquals(a1[s], a2[s])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(ObjectArrayList l) {
        int i1;
        int s1 = this.size();
        int s2 = l.size();
        Object[] a1 = this.a;
        Object[] a2 = l.a;
        int n = 0;
        for (i1 = 0; n < s1 && i1 < s2; ++i1) {
            void r;
            int i2 = ((Comparable)a1[n]).compareTo(a2[i1]);
            if (i2 != 0) {
                return i2;
            }
            ++r;
        }
        return i1 < s2 ? -1 : (n < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.a[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.a = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.a[i] = s.readObject();
        }
    }
}

