/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.ints.IntArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import clover.it.unimi.dsi.fastutil.objects.ObjectIndirectHeaps;
import java.util.Comparator;

public class ObjectHeapIndirectPriorityQueue
extends ObjectHeapSemiIndirectPriorityQueue {
    protected int[] inv;

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, int capacity, Comparator c) {
        super(refArray, capacity, c);
        if (capacity > 0) {
            this.heap = new int[capacity];
        }
        this.refArray = refArray;
        this.c = c;
        this.inv = new int[refArray.length];
        IntArrays.fill((int[])this.inv, (int)-1);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, Comparator c) {
        this(refArray, refArray.length, c);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, int[] a, int size, Comparator c) {
        this(refArray, 0, c);
        this.heap = a;
        this.size = size;
        int i = size;
        while (i-- != 0) {
            if (this.inv[a[i]] != -1) {
                throw new IllegalArgumentException("Index " + a[i] + " appears twice in the heap");
            }
            this.inv[a[i]] = i;
        }
        ObjectIndirectHeaps.makeHeap(refArray, a, this.inv, size, c);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, int[] a, Comparator c) {
        this(refArray, a, a.length, c);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public ObjectHeapIndirectPriorityQueue(Object[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    protected void ensureHeapElement(int index) {
        this.ensureElement(index);
        if (this.inv[index] < 0) {
            throw new IllegalArgumentException("Index " + index + " does not belong to the queue");
        }
    }

    protected void ensureNotHeapElement(int index) {
        this.ensureElement(index);
        if (this.inv[index] >= 0) {
            throw new IllegalArgumentException("Index " + index + " belongs to the queue");
        }
    }

    public void enqueue(int x) {
        this.ensureNotHeapElement(x);
        if (this.size == this.heap.length) {
            this.heap = IntArrays.grow((int[])this.heap, (int)(this.size + 1));
        }
        this.heap[this.size] = x;
        this.inv[this.heap[this.size]] = this.size++;
        ObjectIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, this.size - 1, this.c);
    }

    public int dequeue() {
        this.ensureNonEmpty();
        int result = this.heap[0];
        if (--this.size != 0) {
            this.heap[0] = this.heap[this.size];
            this.inv[this.heap[0]] = 0;
        }
        this.inv[result] = -1;
        if (this.size != 0) {
            ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, 0, this.c);
        }
        return result;
    }

    public void changed() {
        this.ensureNonEmpty();
        ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, 0, this.c);
    }

    public void changed(int index) {
        this.ensureHeapElement(index);
        int newPos = ObjectIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, this.inv[index], this.c);
        ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, newPos, this.c);
    }

    public void allChanged() {
        ObjectIndirectHeaps.makeHeap(this.refArray, this.heap, this.inv, this.size, this.c);
    }

    public void remove(int index) {
        this.ensureHeapElement(index);
        int result = this.inv[index];
        this.inv[index] = -1;
        if (result < --this.size) {
            this.heap[result] = this.heap[this.size];
            this.inv[this.heap[result]] = result;
            int newPos = ObjectIndirectHeaps.upHeap(this.refArray, this.heap, this.inv, this.size, result, this.c);
            ObjectIndirectHeaps.downHeap(this.refArray, this.heap, this.inv, this.size, newPos, this.c);
        }
    }

    public void clear() {
        this.size = 0;
        IntArrays.fill((int[])this.inv, (int)-1);
    }
}

