/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.axis;

import clover.org.jfree.chart.Effect3D;
import clover.org.jfree.chart.axis.AxisState;
import clover.org.jfree.chart.axis.NumberAxis;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.Plot;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.renderer.category.CategoryItemRenderer;
import clover.org.jfree.ui.RectangleEdge;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;

public class NumberAxis3D
extends NumberAxis
implements Serializable {
    private static final long serialVersionUID = -1790205852569123512L;

    public NumberAxis3D() {
        this(null);
    }

    public NumberAxis3D(String label) {
        super(label);
        this.setAxisLineVisible(false);
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        double yOffset;
        CategoryPlot categoryPlot;
        CategoryItemRenderer categoryItemRenderer;
        if (!this.isVisible()) {
            AxisState state = new AxisState(cursor);
            List ticks = this.refreshTicks(g2, state, dataArea, edge);
            state.setTicks(ticks);
            return state;
        }
        double d = 0.0;
        double d2 = 0.0;
        Plot plot = this.getPlot();
        if (plot instanceof CategoryPlot && (categoryItemRenderer = (categoryPlot = (CategoryPlot)plot).getRenderer()) instanceof Effect3D) {
            Effect3D effect3D = (Effect3D)((Object)categoryItemRenderer);
            yOffset = effect3D.getXOffset();
            d2 = effect3D.getYOffset();
        }
        double d3 = dataArea.getMinX();
        double d4 = dataArea.getMinY();
        double d5 = dataArea.getWidth() - yOffset;
        double d6 = dataArea.getHeight() - d2;
        if (edge == RectangleEdge.LEFT || edge == RectangleEdge.BOTTOM) {
            d4 += d2;
        } else if (edge == RectangleEdge.RIGHT || edge == RectangleEdge.TOP) {
            d3 += yOffset;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        AxisState axisState = this.drawTickMarksAndLabels(g2, cursor, plotArea, double_, edge);
        axisState = this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, axisState);
        return axisState;
    }
}

