/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.plot;

import clover.org.jfree.chart.LegendItemCollection;
import clover.org.jfree.chart.event.PlotChangeEvent;
import clover.org.jfree.chart.needle.ArrowNeedle;
import clover.org.jfree.chart.needle.LineNeedle;
import clover.org.jfree.chart.needle.LongNeedle;
import clover.org.jfree.chart.needle.MeterNeedle;
import clover.org.jfree.chart.needle.MiddlePinNeedle;
import clover.org.jfree.chart.needle.PinNeedle;
import clover.org.jfree.chart.needle.PlumNeedle;
import clover.org.jfree.chart.needle.PointerNeedle;
import clover.org.jfree.chart.needle.ShipNeedle;
import clover.org.jfree.chart.needle.WindNeedle;
import clover.org.jfree.chart.plot.Plot;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.PlotState;
import clover.org.jfree.data.general.DefaultValueDataset;
import clover.org.jfree.data.general.ValueDataset;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.ui.RectangleInsets;
import clover.org.jfree.util.ObjectUtilities;
import clover.org.jfree.util.PaintUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ResourceBundle;

public class CompassPlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6924382802125527395L;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int labelType;
    private Font labelFont;
    private boolean drawBorder = false;
    private transient Paint roseHighlightPaint = Color.black;
    private transient Paint rosePaint = Color.yellow;
    private transient Paint roseCenterPaint = Color.white;
    private Font compassFont = new Font("Arial", 0, 10);
    private transient Ellipse2D circle1;
    private transient Ellipse2D circle2;
    private transient Area a1;
    private transient Area a2;
    private transient Rectangle2D rect1;
    private ValueDataset[] datasets = new ValueDataset[1];
    private MeterNeedle[] seriesNeedle = new MeterNeedle[1];
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("clover.org.jfree.chart.plot.LocalizationBundle");
    protected double revolutionDistance = 360.0;

    public CompassPlot() {
        this(new DefaultValueDataset());
    }

    public CompassPlot(ValueDataset dataset) {
        if (dataset != null) {
            this.datasets[0] = dataset;
            dataset.addChangeListener(this);
        }
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.rect1 = new Rectangle2D.Double();
        this.setSeriesNeedle(0);
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != type) {
            this.labelType = type;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' not allowed.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRosePaint() {
        return this.rosePaint;
    }

    public void setRosePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rosePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRoseCenterPaint() {
        return this.roseCenterPaint;
    }

    public void setRoseCenterPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.roseCenterPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRoseHighlightPaint() {
        return this.roseHighlightPaint;
    }

    public void setRoseHighlightPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.roseHighlightPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean status) {
        this.drawBorder = status;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSeriesPaint(int series, Paint paint) {
        if (series >= 0 && series < this.seriesNeedle.length) {
            this.seriesNeedle[series].setFillPaint(paint);
        }
    }

    public void setSeriesOutlinePaint(int series, Paint p) {
        if (series >= 0 && series < this.seriesNeedle.length) {
            this.seriesNeedle[series].setOutlinePaint(p);
        }
    }

    public void setSeriesOutlineStroke(int series, Stroke stroke) {
        if (series >= 0 && series < this.seriesNeedle.length) {
            this.seriesNeedle[series].setOutlineStroke(stroke);
        }
    }

    public void setSeriesNeedle(int type) {
        this.setSeriesNeedle(0, type);
    }

    public void setSeriesNeedle(int index, int type) {
        switch (type) {
            case 0: {
                this.setSeriesNeedle(index, new ArrowNeedle(true));
                this.setSeriesPaint(index, Color.red);
                this.seriesNeedle[index].setHighlightPaint(Color.white);
                break;
            }
            case 1: {
                this.setSeriesNeedle(index, new LineNeedle());
                break;
            }
            case 2: {
                LongNeedle longNeedle = new LongNeedle();
                longNeedle.setRotateY(0.5);
                this.setSeriesNeedle(index, longNeedle);
                break;
            }
            case 3: {
                this.setSeriesNeedle(index, new PinNeedle());
                break;
            }
            case 4: {
                this.setSeriesNeedle(index, new PlumNeedle());
                break;
            }
            case 5: {
                this.setSeriesNeedle(index, new PointerNeedle());
                break;
            }
            case 6: {
                this.setSeriesPaint(index, null);
                this.setSeriesOutlineStroke(index, new BasicStroke(3.0f));
                this.setSeriesNeedle(index, new ShipNeedle());
                break;
            }
            case 7: {
                this.setSeriesPaint(index, Color.blue);
                this.setSeriesNeedle(index, new WindNeedle());
                break;
            }
            case 8: {
                this.setSeriesNeedle(index, new ArrowNeedle(true));
                break;
            }
            case 9: {
                this.setSeriesNeedle(index, new MiddlePinNeedle());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised type.");
            }
        }
    }

    public void setSeriesNeedle(int index, MeterNeedle needle) {
        if (needle != null && index < this.seriesNeedle.length) {
            this.seriesNeedle[index] = needle;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueDataset[] getDatasets() {
        return this.datasets;
    }

    public void addDataset(ValueDataset dataset) {
        this.addDataset(dataset, null);
    }

    public void addDataset(ValueDataset dataset, MeterNeedle needle) {
        if (dataset != null) {
            int i = this.datasets.length + 1;
            ValueDataset[] t = new ValueDataset[i];
            MeterNeedle[] p = new MeterNeedle[i];
            i -= 2;
            while (i >= 0) {
                t[i] = this.datasets[i];
                p[i] = this.seriesNeedle[i];
                --i;
            }
            i = this.datasets.length;
            t[i] = dataset;
            p[i] = needle != null ? needle : p[i - 1];
            ValueDataset[] a = this.datasets;
            MeterNeedle[] b = this.seriesNeedle;
            this.datasets = t;
            this.seriesNeedle = p;
            --i;
            while (i >= 0) {
                a[i] = null;
                b[i] = null;
                --i;
            }
            dataset.addChangeListener(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        void y1;
        int diameter;
        double d;
        int insets2;
        int outerRadius = 0;
        int innerRadius = 0;
        if (info != null) {
            info.setPlotArea(area);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(area);
        if (this.drawBorder) {
            this.drawBackground(g2, area);
        }
        int n = (int)(area.getWidth() / 2.0);
        int n2 = (int)(area.getHeight() / 2.0);
        int n3 = n;
        if (n2 < n) {
            n3 = n2;
        }
        int n4 = 2 * --n3;
        this.circle1.setFrame((n += (int)area.getMinX()) - n3, (n2 += (int)area.getMinY()) - n3, n4, n4);
        this.circle2.setFrame(n - n3 + 15, n2 - n3 + 15, n4 - 30, n4 - 30);
        g2.setPaint(this.rosePaint);
        this.a1 = new Area(this.circle1);
        this.a2 = new Area(this.circle2);
        this.a1.subtract(this.a2);
        g2.fill(this.a1);
        g2.setPaint(this.roseCenterPaint);
        int n5 = n4 - 30;
        g2.fillOval(n - n3 + 15, n2 - n3 + 15, n5, n5);
        g2.setPaint(this.roseHighlightPaint);
        g2.drawOval(n - n3, n2 - n3, n4, n4);
        n5 = n4 - 20;
        g2.drawOval(n - n3 + 10, n2 - n3 + 10, n5, n5);
        n5 = n4 - 30;
        g2.drawOval(n - n3 + 15, n2 - n3 + 15, n5, n5);
        n5 = n4 - 80;
        g2.drawOval(n - n3 + 40, n2 - n3 + 40, n5, n5);
        outerRadius = n3 - 20;
        innerRadius = n3 - 32;
        for (insets2 = 0; insets2 < 360; insets2 += 15) {
            void x2;
            d = Math.toRadians(insets2);
            n5 = n - (int)(Math.sin(d) * (double)innerRadius);
            int radius = n - (int)(Math.sin(d) * (double)outerRadius);
            diameter = x2 - (int)(Math.cos(d) * (double)innerRadius);
            void w = x2 - (int)(Math.cos(d) * (double)outerRadius);
            g2.drawLine(n5, diameter, radius, (int)w);
        }
        g2.setPaint(this.roseHighlightPaint);
        innerRadius = n3 - 26;
        outerRadius = 7;
        for (insets2 = 45; insets2 < 360; insets2 += 90) {
            d = Math.toRadians(insets2);
            n5 = y1 - (int)(Math.sin(d) * (double)innerRadius);
            diameter = n2 - (int)(Math.cos(d) * (double)innerRadius);
            g2.fillOval(n5 - outerRadius, diameter - outerRadius, 2 * outerRadius, 2 * outerRadius);
        }
        for (insets2 = 0; insets2 < 360; insets2 += 90) {
            d = Math.toRadians(insets2);
            n5 = y1 - (int)(Math.sin(d) * (double)innerRadius);
            diameter = n2 - (int)(Math.cos(d) * (double)innerRadius);
            Polygon p = new Polygon();
            p.addPoint(n5 - outerRadius, diameter);
            p.addPoint(n5, diameter + outerRadius);
            p.addPoint(n5 + outerRadius, diameter);
            p.addPoint(n5, diameter - outerRadius);
            g2.fillPolygon(p);
        }
        innerRadius = n3 - 42;
        Font insets2 = this.getCompassFont(n3);
        g2.setFont(insets2);
        g2.drawString("N", (int)(y1 - 5), n2 - innerRadius + insets2.getSize());
        g2.drawString("S", (int)(y1 - 5), n2 + innerRadius - 5);
        g2.drawString("W", (int)(y1 - innerRadius + 5), n2 + 5);
        g2.drawString("E", (int)(y1 + innerRadius - insets2.getSize()), n2 + 5);
        diameter = n3 / 2;
        n5 = n3 / 6;
        Rectangle2D.Double needleArea = new Rectangle2D.Double((double)(y1 - n5), n2 - diameter, 2 * n5, 2 * diameter);
        int x = this.seriesNeedle.length;
        int current = 0;
        double value = 0.0;
        for (int i = this.datasets.length - 1; i >= 0; --i) {
            ValueDataset data = this.datasets[i];
            if (data == null || data.getValue() == null) continue;
            value = data.getValue().doubleValue() % this.revolutionDistance;
            value = value / this.revolutionDistance * 360.0;
            current = i % x;
            this.seriesNeedle[current].draw(g2, needleArea, value);
        }
        if (this.drawBorder) {
            this.drawOutline(g2, area);
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Compass_Plot");
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void zoom(double percent) {
    }

    protected Font getCompassFont(int radius) {
        float fontSize = (float)radius / 10.0f;
        if (fontSize < 8.0f) {
            fontSize = 8.0f;
        }
        Font newFont = this.compassFont.deriveFont(fontSize);
        return newFont;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompassPlot)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        CompassPlot that = (CompassPlot)obj;
        if (this.labelType != that.labelType) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelFont, that.labelFont)) {
            return false;
        }
        if (this.drawBorder != that.drawBorder) {
            return false;
        }
        if (!PaintUtilities.equal(this.roseHighlightPaint, that.roseHighlightPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rosePaint, that.rosePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.roseCenterPaint, that.roseCenterPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.compassFont, that.compassFont)) {
            return false;
        }
        if (!Arrays.equals(this.seriesNeedle, that.seriesNeedle)) {
            return false;
        }
        return this.getRevolutionDistance() == that.getRevolutionDistance();
    }

    public Object clone() throws CloneNotSupportedException {
        CompassPlot clone = (CompassPlot)super.clone();
        if (this.circle1 != null) {
            clone.circle1 = (Ellipse2D)this.circle1.clone();
        }
        if (this.circle2 != null) {
            clone.circle2 = (Ellipse2D)this.circle2.clone();
        }
        if (this.a1 != null) {
            clone.a1 = (Area)this.a1.clone();
        }
        if (this.a2 != null) {
            clone.a2 = (Area)this.a2.clone();
        }
        if (this.rect1 != null) {
            clone.rect1 = (Rectangle2D)this.rect1.clone();
        }
        clone.datasets = (ValueDataset[])this.datasets.clone();
        clone.seriesNeedle = (MeterNeedle[])this.seriesNeedle.clone();
        for (int i = 0; i < this.datasets.length; ++i) {
            if (clone.datasets[i] == null) continue;
            clone.datasets[i].addChangeListener(clone);
        }
        return clone;
    }

    public void setRevolutionDistance(double size) {
        if (size > 0.0) {
            this.revolutionDistance = size;
        }
    }

    public double getRevolutionDistance() {
        return this.revolutionDistance;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.rosePaint, stream);
        SerialUtilities.writePaint(this.roseCenterPaint, stream);
        SerialUtilities.writePaint(this.roseHighlightPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.rosePaint = SerialUtilities.readPaint(stream);
        this.roseCenterPaint = SerialUtilities.readPaint(stream);
        this.roseHighlightPaint = SerialUtilities.readPaint(stream);
    }
}

