/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.xy;

import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.XYPlot;
import clover.org.jfree.chart.renderer.xy.XYItemRendererState;
import clover.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.ui.RectangleEdge;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private Vector points;
    private int precision;

    public XYSplineRenderer() {
        this(5);
    }

    public XYSplineRenderer(int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = p;
        this.fireChangeEvent();
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYLineAndShapeRenderer.State state = (XYLineAndShapeRenderer.State)super.initialise(g2, dataArea, plot, data, info);
        state.setProcessVisibleItemsOnly(false);
        this.points = new Vector();
        this.setDrawSeriesLineAsPath(true);
        return state;
    }

    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        ControlPoint p;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (!(Double.isNaN(transX1) || Double.isNaN(transY1) || this.points.contains(p = new ControlPoint(plot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)transY1 : (float)transX1, plot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)transX1 : (float)transY1)))) {
            this.points.add(p);
        }
        if (item == dataset.getItemCount(series) - 1) {
            XYLineAndShapeRenderer.State s = (XYLineAndShapeRenderer.State)state;
            if (this.points.size() > 1) {
                ControlPoint cp0 = (ControlPoint)this.points.get(0);
                s.seriesPath.moveTo(cp0.x, cp0.y);
                if (this.points.size() == 2) {
                    ControlPoint cp1 = (ControlPoint)this.points.get(1);
                    s.seriesPath.lineTo(cp1.x, cp1.y);
                } else {
                    int h;
                    Object object;
                    int a2;
                    int np = this.points.size();
                    float[] d = new float[np];
                    float[] x = new float[np];
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float[] oldy = new float[np];
                    float[] oldt = new float[np];
                    for (a2 = 0; a2 < np; ++a2) {
                        object = (ControlPoint)this.points.get(a2);
                        x[a2] = ((ControlPoint)object).x;
                        d[a2] = ((ControlPoint)object).y;
                    }
                    for (a2 = 1; a2 <= np - 1; ++a2) {
                        oldt[a2] = x[a2] - x[a2 - 1];
                    }
                    float[] a2 = new float[np - 1];
                    object = new float[np - 1];
                    float[] fArray = new float[np - 1];
                    for (h = 1; h <= np - 2; ++h) {
                        object[h] = (oldt[h] + oldt[h + 1]) / 3.0f;
                        fArray[h] = oldt[h + 1] / 6.0f;
                        a2[h] = oldt[h] / 6.0f;
                        oldy[h] = (d[h + 1] - d[h]) / oldt[h + 1] - (d[h] - d[h - 1]) / oldt[h];
                    }
                    this.solveTridiag(a2, (float[])object, fArray, oldy, np - 2);
                    f2 = x[0];
                    f = d[0];
                    s.seriesPath.moveTo(f2, f);
                    for (h = 1; h <= np - 1; ++h) {
                        for (int sub = 1; sub <= this.precision; ++sub) {
                            float diag = oldt[h] * (float)sub / (float)this.precision;
                            float sup = oldt[h] - diag;
                            float i = ((-oldy[h - 1] / 6.0f * (sup + oldt[h]) * diag + d[h - 1]) * sup + (-oldy[h] / 6.0f * (diag + oldt[h]) * sup + d[h]) * diag) / oldt[h];
                            float j = x[h - 1] + diag;
                            s.seriesPath.lineTo(j, i);
                            float t = j;
                            float y = i;
                        }
                    }
                }
                this.drawFirstPassShape(g2, pass, series, item, s.seriesPath);
            }
            this.points = new Vector();
        }
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b, int n) {
        int i;
        for (i = 2; i <= n; ++i) {
            sub[i] = sub[i] / diag[i - 1];
            diag[i] = diag[i] - sub[i] * sup[i - 1];
            b[i] = b[i] - sub[i] * b[i - 1];
        }
        b[n] = b[n] / diag[n];
        for (i = n - 1; i >= 1; --i) {
            b[i] = (b[i] - sup[i] * b[i + 1]) / diag[i];
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer that = (XYSplineRenderer)obj;
        if (this.precision != that.precision) {
            return false;
        }
        return super.equals(obj);
    }

    class ControlPoint {
        public float x;
        public float y;

        public ControlPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ControlPoint)) {
                return false;
            }
            ControlPoint that = (ControlPoint)obj;
            return this.x == that.x;
        }
    }
}

