/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.data.xy;

import clover.org.jfree.util.ObjectUtilities;
import java.io.Serializable;

public class XYDataItem
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 2751513470325494890L;
    private Number x;
    private Number y;

    public XYDataItem(Number x, Number y) {
        if (x == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        this.x = x;
        this.y = y;
    }

    public XYDataItem(double x, double y) {
        this(new Double(x), new Double(y));
    }

    public Number getX() {
        return this.x;
    }

    public Number getY() {
        return this.y;
    }

    public void setY(double y) {
        this.setY(new Double(y));
    }

    public void setY(Number y) {
        this.y = y;
    }

    public int compareTo(Object o1) {
        int n;
        if (o1 instanceof XYDataItem) {
            XYDataItem xYDataItem = (XYDataItem)o1;
            double d = this.x.doubleValue() - xYDataItem.getX().doubleValue();
            n = d > 0.0 ? 1 : (d < 0.0 ? -1 : 0);
        } else {
            n = 1;
        }
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYDataItem)) {
            return false;
        }
        XYDataItem that = (XYDataItem)obj;
        if (!this.x.equals(that.x)) {
            return false;
        }
        return ObjectUtilities.equal(this.y, that.y);
    }

    public int hashCode() {
        int result = this.x.hashCode();
        result = 29 * result + (this.y != null ? this.y.hashCode() : 0);
        return result;
    }
}

