/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.reporters.html.ClassInfoClosure;
import com.cenqua.clover.util.Formatting;

public abstract class AbstractClassInfoClosure
implements ClassInfoClosure {
    public boolean ignore(BaseClassInfo classInfo) {
        return false;
    }

    public static class PcCoveredElementsClosure
    extends AbstractClassInfoClosure {
        public boolean ignore(BaseClassInfo classInfo) {
            return this.getScaledValue(classInfo) == 0 || this.getScaledValue(classInfo) < 0;
        }

        public float getValue(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getPcUncoveredElements();
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.getPercentStr(classInfo.getMetrics().getPcCoveredElements());
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            int i = (int)(this.getValue(classInfo) * 100.0f);
            return i;
        }

        public String getName() {
            return "Coverage";
        }
    }

    public static class AvgMethodComplexityClosure
    extends AbstractClassInfoClosure {
        public boolean ignore(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getNumElements() <= 0;
        }

        public float getValue(BaseClassInfo classInfo) {
            float value = ((ClassMetrics)classInfo.getMetrics()).getAvgMethodComplexity();
            return value > 0.0f ? value : 0.0f;
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.format3d(this.getValue(classInfo));
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)(this.getValue(classInfo) * 100.0f);
        }

        public String getName() {
            return "Average Method Complexity";
        }
    }

    public static class UncoveredElementsClosure
    extends AbstractClassInfoClosure {
        public boolean ignore(BaseClassInfo classInfo) {
            return this.getValue(classInfo) <= 0.0f;
        }

        public float getValue(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getNumUncoveredElements();
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.formatInt((int)this.getValue(classInfo));
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)this.getValue(classInfo);
        }

        public String getName() {
            return "# Elements Untested";
        }
    }

    public static class ElementCountClosure
    extends AbstractClassInfoClosure {
        public float getValue(BaseClassInfo classInfo) {
            return classInfo.getMetrics().getNumElements();
        }

        public String getFormattedValue(BaseClassInfo classInfo) {
            return Formatting.formatInt((int)this.getValue(classInfo));
        }

        public int getScaledValue(BaseClassInfo classInfo) {
            return (int)this.getValue(classInfo);
        }

        public String getName() {
            return "# Elements";
        }

        public boolean ignore(BaseClassInfo classInfo) {
            return this.getValue(classInfo) <= 0.0f;
        }
    }
}

