/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.util;

import clover.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import clover.edu.emory.mathcs.backport.java.util.concurrent.Executors;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import clover.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import com.cenqua.clover.util.CloverExecutor;

public class CloverExecutors {
    private CloverExecutors() {
    }

    public static CloverExecutor newCloverExecutor(int numThreads, String threadPrefix) {
        return new CloverExecutorService(numThreads, threadPrefix);
    }

    private static class CloverExecutorService
    implements CloverExecutor {
        private final ExecutorService service;

        public CloverExecutorService(int numThreads, final String threadPrefix) {
            this.service = numThreads > 0 ? Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setName(threadPrefix + "-" + thread.getName());
                    return thread;
                }
            }) : null;
        }

        public void shutdown() {
            if (this.service != null) {
                this.service.shutdown();
            }
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.service == null || this.service.awaitTermination(timeout, unit);
        }

        public void submit(Callable task) throws Exception {
            if (this.service != null) {
                this.service.submit(task);
            } else {
                task.call();
            }
        }
    }
}

