/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.bus.extension.ExtensionFragmentParser;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ObjectTypeResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.resource.SinglePropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManagerImpl
implements ExtensionManager {
    public static final String EXTENSIONMANAGER_PROPERTY_NAME = "extensionManager";
    public static final String ACTIVATION_NAMESPACES_PROPERTY_NAME = "activationNamespaces";
    public static final String BUS_EXTENSION_RESOURCE = "META-INF/bus-extensions.xml";
    private final ClassLoader loader;
    private ResourceManager resourceManager;
    private Map<String, Collection<Extension>> deferred;
    private final Map<Class, Object> activated;
    private final Map<String, Collection<Object>> namespaced = new ConcurrentHashMap<String, Collection<Object>>();

    public ExtensionManagerImpl(ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm) {
        this(BUS_EXTENSION_RESOURCE, cl, initialExtensions, rm);
    }

    public ExtensionManagerImpl(String resource, ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm) {
        this.loader = cl;
        this.activated = initialExtensions;
        this.resourceManager = rm;
        SinglePropertyResolver extensionManagerResolver = new SinglePropertyResolver(EXTENSIONMANAGER_PROPERTY_NAME, (Object)this);
        this.resourceManager.addResourceResolver((ResourceResolver)extensionManagerResolver);
        this.resourceManager.addResourceResolver((ResourceResolver)new ObjectTypeResolver((Object)this));
        this.deferred = new ConcurrentHashMap<String, Collection<Extension>>();
        try {
            this.load(resource);
        }
        catch (IOException ex) {
            throw new ExtensionException(ex);
        }
    }

    @Override
    public synchronized void activateViaNS(String namespaceURI) {
        Collection<Extension> extensions = this.deferred.get(namespaceURI);
        if (null == extensions) {
            return;
        }
        for (Extension e : extensions) {
            this.loadAndRegister(e);
        }
        extensions.clear();
        this.deferred.remove(namespaceURI);
    }

    @Override
    public synchronized void activateAll() {
        while (!this.deferred.isEmpty()) {
            this.activateViaNS(this.deferred.keySet().iterator().next());
        }
    }

    final void load(String resource) throws IOException {
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            this.loadFragment(is);
        }
    }

    final void loadFragment(InputStream is) {
        List<Extension> extensions = new ExtensionFragmentParser().getExtensions(is);
        for (Extension e : extensions) {
            this.processExtension(e);
        }
    }

    final void processExtension(Extension e) {
        if (!e.isDeferred()) {
            this.loadAndRegister(e);
        }
        Collection<String> namespaces = e.getNamespaces();
        for (String ns : namespaces) {
            Collection<Extension> extensions = this.deferred.get(ns);
            if (null == extensions) {
                extensions = new ArrayList<Extension>();
                this.deferred.put(ns, extensions);
            }
            extensions.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadAndRegister(Extension e) {
        Class<?> cls = null;
        if (null != e.getInterfaceName() && !"".equals(e.getInterfaceName())) {
            cls = e.loadInterface(this.loader);
        }
        if (null != this.activated && null != cls && null != this.activated.get(cls)) {
            return;
        }
        Object obj = e.load(this.loader);
        Configurer configurer = (Configurer)this.activated.get(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(obj);
        }
        SinglePropertyResolver namespacesResolver = null;
        if (null != e.getNamespaces()) {
            namespacesResolver = new SinglePropertyResolver(ACTIVATION_NAMESPACES_PROPERTY_NAME, e.getNamespaces());
            this.resourceManager.addResourceResolver((ResourceResolver)namespacesResolver);
        }
        ResourceInjector injector = new ResourceInjector(this.resourceManager);
        try {
            injector.inject(obj);
            injector.construct(obj);
        }
        finally {
            if (null != namespacesResolver) {
                this.resourceManager.removeResourceResolver((ResourceResolver)namespacesResolver);
            }
        }
        if (null != this.activated) {
            if (cls == null) {
                cls = obj.getClass();
            }
            this.activated.put(cls, obj);
        }
        for (String ns : e.getNamespaces()) {
            Collection<Object> intf2Obj = this.namespaced.get(ns);
            if (intf2Obj == null) {
                intf2Obj = new ArrayList<Object>();
                if (!this.namespaced.containsKey(ns)) {
                    this.namespaced.put(ns, intf2Obj);
                }
            }
            intf2Obj.add(obj);
        }
    }

    @Override
    public <T> T getExtension(String ns, Class<T> type) {
        Collection<Object> nsExts = this.namespaced.get(ns);
        if (nsExts != null) {
            for (Object o : nsExts) {
                if (!type.isAssignableFrom(o.getClass())) continue;
                return type.cast(o);
            }
        }
        return null;
    }
}

