/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingInInterceptor.class);
    private int limit = 102400;

    public LoggingInInterceptor() {
        super("receive");
    }

    public LoggingInInterceptor(int lim) {
        super("receive");
        this.limit = lim;
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public void handleMessage(Message message) throws Fault {
        if (LOG.isLoggable(Level.INFO)) {
            InputStream is;
            Object headers;
            StringBuilder buffer = new StringBuilder(2048);
            buffer.append("Inbound Message\n").append("--------------------------------------");
            String encoding = (String)message.get((Object)Message.ENCODING);
            if (encoding != null) {
                buffer.append("\nEncoding: " + encoding);
            }
            if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
                buffer.append("\nHeaders: " + headers);
            }
            if ((is = (InputStream)message.getContent(InputStream.class)) != null) {
                CachedOutputStream bos = new CachedOutputStream();
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                    bos.flush();
                    is.close();
                    message.setContent(InputStream.class, (Object)bos.getInputStream());
                    if (bos.getTempFile() != null) {
                        buffer.append("\nMessage (saved to tmp file):\n");
                        buffer.append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                    } else {
                        buffer.append("\nMessage:\n");
                    }
                    if (bos.size() > this.limit) {
                        buffer.append("(message truncated to " + this.limit + " bytes)\n");
                    }
                    bos.writeCacheTo(buffer, this.limit);
                    bos.close();
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
            buffer.append("\n--------------------------------------");
            LOG.info(buffer.toString());
        }
    }
}

