/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.container;

import com.sun.ws.rest.api.container.ContainerException;
import com.sun.ws.rest.api.core.ClasspathResourceConfig;
import com.sun.ws.rest.api.core.DefaultResourceConfig;
import com.sun.ws.rest.api.core.ResourceConfig;
import com.sun.ws.rest.spi.container.ContainerProvider;
import com.sun.ws.rest.spi.container.WebApplication;
import com.sun.ws.rest.spi.container.WebApplicationFactory;
import com.sun.ws.rest.spi.service.ServiceFinder;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerFactory {
    private ContainerFactory() {
    }

    public static <A> A createContainer(Class<A> type, Class ... resourceClasses) throws ContainerException, IllegalArgumentException {
        HashSet<Class> resourceClassesSet = new HashSet<Class>(Arrays.asList(resourceClasses));
        return ContainerFactory.createContainer(type, new DefaultResourceConfig(resourceClassesSet));
    }

    public static <A> A createContainer(Class<A> type, Set<Class> resourceClasses) throws ContainerException, IllegalArgumentException {
        return ContainerFactory.createContainer(type, new DefaultResourceConfig(resourceClasses));
    }

    public static <A> A createContainer(Class<A> type, ResourceConfig resourceConfig) throws ContainerException, IllegalArgumentException {
        WebApplication wa = WebApplicationFactory.createWebApplication();
        for (ContainerProvider rp : ServiceFinder.find(ContainerProvider.class, true)) {
            A r = rp.createContainer(type, resourceConfig, wa);
            if (r == null) continue;
            return r;
        }
        throw new IllegalArgumentException("No container provider supports the type " + type);
    }

    public static <A> A createContainer(Class<A> type, String packageName) throws ContainerException, IllegalArgumentException {
        String resourcesClassName = packageName + ".WebResources";
        try {
            Class<?> resourcesClass = ContainerFactory.class.getClassLoader().loadClass(resourcesClassName);
            ResourceConfig config = (ResourceConfig)resourcesClass.newInstance();
            return ContainerFactory.createContainer(type, config);
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException(e);
        }
        catch (InstantiationException e) {
            throw new ContainerException(e);
        }
        catch (IllegalAccessException e) {
            throw new ContainerException(e);
        }
    }

    public static <A> A createContainer(Class<A> type) {
        String classPath = System.getProperty("java.class.path");
        String[] paths = classPath.split(File.pathSeparator);
        return ContainerFactory.createContainer(type, paths);
    }

    public static <A> A createContainer(Class<A> type, String ... paths) {
        ClasspathResourceConfig config = new ClasspathResourceConfig(paths);
        return ContainerFactory.createContainer(type, config);
    }
}

