/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ws.rest.api.core;

import com.sun.ws.rest.api.core.DefaultResourceConfig;
import com.sun.ws.rest.impl.container.config.AnnotatedClassScanner;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClasspathResourceConfig
extends DefaultResourceConfig {
    public static final String PROPERTY_CLASSPATH = "com.sun.ws.rest.config.property.classpath";
    private static final Logger LOGGER = Logger.getLogger(ClasspathResourceConfig.class.getName());

    public ClasspathResourceConfig(String[] paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Array of paths must not be null or empty");
        }
        this.init(paths);
    }

    public ClasspathResourceConfig(Map<String, Object> props) {
        this(ClasspathResourceConfig.getPaths(props));
        this.getProperties().putAll(props);
    }

    private void init(String[] paths) {
        File[] roots = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            roots[i] = new File(paths[i]);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder b = new StringBuilder();
            b.append("Scanning for root resource and provider classes in the paths:");
            for (String p : paths) {
                b.append('\n').append("  ").append(p);
            }
            LOGGER.log(Level.INFO, b.toString());
        }
        AnnotatedClassScanner scanner = new AnnotatedClassScanner(Path.class, Provider.class);
        scanner.scan(roots);
        this.getResourceClasses().addAll(scanner.getMatchingClasses(Path.class));
        this.getProviderClasses().addAll(scanner.getMatchingClasses(Provider.class));
        if (LOGGER.isLoggable(Level.INFO) && !this.getResourceClasses().isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Root resource classes found:");
            for (Class c : this.getResourceClasses()) {
                b.append('\n').append("  ").append(c);
            }
            LOGGER.log(Level.INFO, b.toString());
            b = new StringBuilder();
            b.append("Provider classes found:");
            for (Class c : this.getProviderClasses()) {
                b.append('\n').append("  ").append(c);
            }
            LOGGER.log(Level.INFO, b.toString());
        }
    }

    private static String[] getPaths(Map<String, Object> props) {
        Object v = props.get(PROPERTY_CLASSPATH);
        if (v == null) {
            throw new IllegalArgumentException("com.sun.ws.rest.config.property.classpath property is missing");
        }
        String[] paths = ClasspathResourceConfig.getPaths(v);
        if (paths.length == 0) {
            throw new IllegalArgumentException("com.sun.ws.rest.config.property.classpath contains no paths");
        }
        return paths;
    }

    private static String[] getPaths(Object param) {
        if (param instanceof String) {
            return ClasspathResourceConfig.getPaths((String)param);
        }
        if (param instanceof String[]) {
            return ClasspathResourceConfig.getPaths((String[])param);
        }
        throw new IllegalArgumentException("com.sun.ws.rest.config.property.classpath must have a property value of type String or String[]");
    }

    private static String[] getPaths(String[] elements) {
        LinkedList paths = new LinkedList();
        for (String element : elements) {
            if (element == null || element.length() == 0) continue;
            Collections.addAll(paths, ClasspathResourceConfig.getPaths(element));
        }
        return paths.toArray(new String[paths.size()]);
    }

    private static String[] getPaths(String paths) {
        return paths.split(";");
    }
}

